<?php //401898b22d273ea42e1d92c448d6ed2f
/** @noinspection all */

namespace App\Models {

    use Database\Factories\AdminFactory;
    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphTo;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use Laravel\Sanctum\PersonalAccessToken;
    use LaravelIdea\Helper\App\Models\_IH_Admin_C;
    use LaravelIdea\Helper\App\Models\_IH_Admin_QB;
    use LaravelIdea\Helper\App\Models\_IH_Advertisement_C;
    use LaravelIdea\Helper\App\Models\_IH_Advertisement_QB;
    use LaravelIdea\Helper\App\Models\_IH_Brand_C;
    use LaravelIdea\Helper\App\Models\_IH_Brand_QB;
    use LaravelIdea\Helper\App\Models\_IH_ContactMessage_C;
    use LaravelIdea\Helper\App\Models\_IH_ContactMessage_QB;
    use LaravelIdea\Helper\App\Models\_IH_CouponLog_C;
    use LaravelIdea\Helper\App\Models\_IH_CouponLog_QB;
    use LaravelIdea\Helper\App\Models\_IH_Coupon_C;
    use LaravelIdea\Helper\App\Models\_IH_Coupon_QB;
    use LaravelIdea\Helper\App\Models\_IH_CronjobLog_C;
    use LaravelIdea\Helper\App\Models\_IH_CronjobLog_QB;
    use LaravelIdea\Helper\App\Models\_IH_CustomDomain_C;
    use LaravelIdea\Helper\App\Models\_IH_CustomDomain_QB;
    use LaravelIdea\Helper\App\Models\_IH_FaqCategory_C;
    use LaravelIdea\Helper\App\Models\_IH_FaqCategory_QB;
    use LaravelIdea\Helper\App\Models\_IH_Faq_C;
    use LaravelIdea\Helper\App\Models\_IH_Faq_QB;
    use LaravelIdea\Helper\App\Models\_IH_FormBuilder_C;
    use LaravelIdea\Helper\App\Models\_IH_FormBuilder_QB;
    use LaravelIdea\Helper\App\Models\_IH_ImageGalleryCategory_C;
    use LaravelIdea\Helper\App\Models\_IH_ImageGalleryCategory_QB;
    use LaravelIdea\Helper\App\Models\_IH_ImageGallery_C;
    use LaravelIdea\Helper\App\Models\_IH_ImageGallery_QB;
    use LaravelIdea\Helper\App\Models\_IH_Language_C;
    use LaravelIdea\Helper\App\Models\_IH_Language_QB;
    use LaravelIdea\Helper\App\Models\_IH_MediaUploader_C;
    use LaravelIdea\Helper\App\Models\_IH_MediaUploader_QB;
    use LaravelIdea\Helper\App\Models\_IH_Menu_C;
    use LaravelIdea\Helper\App\Models\_IH_Menu_QB;
    use LaravelIdea\Helper\App\Models\_IH_MetaInfo_C;
    use LaravelIdea\Helper\App\Models\_IH_MetaInfo_QB;
    use LaravelIdea\Helper\App\Models\_IH_Newsletter_C;
    use LaravelIdea\Helper\App\Models\_IH_Newsletter_QB;
    use LaravelIdea\Helper\App\Models\_IH_Notification_C;
    use LaravelIdea\Helper\App\Models\_IH_Notification_QB;
    use LaravelIdea\Helper\App\Models\_IH_Order_C;
    use LaravelIdea\Helper\App\Models\_IH_Order_QB;
    use LaravelIdea\Helper\App\Models\_IH_PackageHistory_C;
    use LaravelIdea\Helper\App\Models\_IH_PackageHistory_QB;
    use LaravelIdea\Helper\App\Models\_IH_PageBuilder_C;
    use LaravelIdea\Helper\App\Models\_IH_PageBuilder_QB;
    use LaravelIdea\Helper\App\Models\_IH_Page_C;
    use LaravelIdea\Helper\App\Models\_IH_Page_QB;
    use LaravelIdea\Helper\App\Models\_IH_PaymentGateway_C;
    use LaravelIdea\Helper\App\Models\_IH_PaymentGateway_QB;
    use LaravelIdea\Helper\App\Models\_IH_PaymentLogHistory_C;
    use LaravelIdea\Helper\App\Models\_IH_PaymentLogHistory_QB;
    use LaravelIdea\Helper\App\Models\_IH_PaymentLogs_C;
    use LaravelIdea\Helper\App\Models\_IH_PaymentLogs_QB;
    use LaravelIdea\Helper\App\Models\_IH_PlanFeature_C;
    use LaravelIdea\Helper\App\Models\_IH_PlanFeature_QB;
    use LaravelIdea\Helper\App\Models\_IH_PricePlan_C;
    use LaravelIdea\Helper\App\Models\_IH_PricePlan_QB;
    use LaravelIdea\Helper\App\Models\_IH_StaticOptionCentral_C;
    use LaravelIdea\Helper\App\Models\_IH_StaticOptionCentral_QB;
    use LaravelIdea\Helper\App\Models\_IH_StaticOption_C;
    use LaravelIdea\Helper\App\Models\_IH_StaticOption_QB;
    use LaravelIdea\Helper\App\Models\_IH_Status_C;
    use LaravelIdea\Helper\App\Models\_IH_Status_QB;
    use LaravelIdea\Helper\App\Models\_IH_SupportDepartment_C;
    use LaravelIdea\Helper\App\Models\_IH_SupportDepartment_QB;
    use LaravelIdea\Helper\App\Models\_IH_SupportTicketMessage_C;
    use LaravelIdea\Helper\App\Models\_IH_SupportTicketMessage_QB;
    use LaravelIdea\Helper\App\Models\_IH_SupportTicket_C;
    use LaravelIdea\Helper\App\Models\_IH_SupportTicket_QB;
    use LaravelIdea\Helper\App\Models\_IH_TenantActivityLog_C;
    use LaravelIdea\Helper\App\Models\_IH_TenantActivityLog_QB;
    use LaravelIdea\Helper\App\Models\_IH_TenantException_C;
    use LaravelIdea\Helper\App\Models\_IH_TenantException_QB;
    use LaravelIdea\Helper\App\Models\_IH_Tenant_C;
    use LaravelIdea\Helper\App\Models\_IH_Tenant_QB;
    use LaravelIdea\Helper\App\Models\_IH_Testimonial_C;
    use LaravelIdea\Helper\App\Models\_IH_Testimonial_QB;
    use LaravelIdea\Helper\App\Models\_IH_Themes_C;
    use LaravelIdea\Helper\App\Models\_IH_Themes_QB;
    use LaravelIdea\Helper\App\Models\_IH_TopbarInfo_C;
    use LaravelIdea\Helper\App\Models\_IH_TopbarInfo_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserDomain_C;
    use LaravelIdea\Helper\App\Models\_IH_UserDomain_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\App\Models\_IH_WeddingPaymentLog_C;
    use LaravelIdea\Helper\App\Models\_IH_WeddingPaymentLog_QB;
    use LaravelIdea\Helper\App\Models\_IH_WeddingPricePlan_C;
    use LaravelIdea\Helper\App\Models\_IH_WeddingPricePlan_QB;
    use LaravelIdea\Helper\App\Models\_IH_Widgets_C;
    use LaravelIdea\Helper\App\Models\_IH_Widgets_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_C;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_Country_QB;
    use LaravelIdea\Helper\Modules\TwoFactorAuthentication\Entities\_IH_LoginSecurity_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WalletHistory_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WalletTenantList_C;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_WalletTenantList_QB;
    use LaravelIdea\Helper\Modules\Wallet\Entities\_IH_Wallet_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_QB;
    use LaravelIdea\Helper\Stancl\Tenancy\Database\Models\_IH_Domain_C;
    use LaravelIdea\Helper\Stancl\Tenancy\Database\Models\_IH_Domain_QB;
    use Modules\CountryManage\Entities\Country;
    use Modules\TwoFactorAuthentication\Entities\LoginSecurity;
    use Modules\Wallet\Entities\Wallet;
    use Modules\Wallet\Entities\WalletHistory;
    use Modules\Wallet\Entities\WalletTenantList;
    use Spatie\Permission\Models\Permission;
    use Spatie\Permission\Models\Role;
    use Stancl\Tenancy\Database\Models\Domain;
    
    /**
     * @property int $id
     * @property string $name
     * @property string $username
     * @property int $email_verified
     * @property string|null $email_verify_token
     * @property string|null $mobile
     * @property string $email
     * @property int|null $image
     * @property Carbon|null $email_verified_at
     * @property string $password
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_Admin_QB onWriteConnection()
     * @method _IH_Admin_QB newQuery()
     * @method static _IH_Admin_QB on(null|string $connection = null)
     * @method static _IH_Admin_QB query()
     * @method static _IH_Admin_QB with(array|string $relations)
     * @method _IH_Admin_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Admin_C|Admin[] all()
     * @foreignLinks id,\Modules\Campaign\Entities\Campaign,admin_id|id,\App\Models\SupportTicket,admin_id|id,\Modules\Blog\Entities\Blog,admin_id
     * @mixin _IH_Admin_QB
     * @method static AdminFactory factory(array|callable|int|null $count = null, array|callable $state = [])
     */
    class Admin extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string $type
     * @property string $size
     * @property string|null $image
     * @property string|null $slot
     * @property string|null $embed_code
     * @property string|null $redirect_url
     * @property int $click
     * @property int $impression
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Advertisement_QB onWriteConnection()
     * @method _IH_Advertisement_QB newQuery()
     * @method static _IH_Advertisement_QB on(null|string $connection = null)
     * @method static _IH_Advertisement_QB query()
     * @method static _IH_Advertisement_QB with(array|string $relations)
     * @method _IH_Advertisement_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Advertisement_C|Advertisement[] all()
     * @mixin _IH_Advertisement_QB
     */
    class Advertisement extends Model {}
    
    /**
     * @property int $id
     * @property string|null $url
     * @property string|null $image
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property MediaUploader|null $getImage
     * @method HasOne|_IH_MediaUploader_QB getImage()
     * @method static _IH_Brand_QB onWriteConnection()
     * @method _IH_Brand_QB newQuery()
     * @method static _IH_Brand_QB on(null|string $connection = null)
     * @method static _IH_Brand_QB query()
     * @method static _IH_Brand_QB with(array|string $relations)
     * @method _IH_Brand_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Brand_C|Brand[] all()
     * @foreignLinks id,\Modules\Product\Entities\Product,brand_id
     * @mixin _IH_Brand_QB
     */
    class Brand extends Model {}
    
    /**
     * @property int $id
     * @property int $form_builder_id
     * @property string|null $fields
     * @property string|null $attachment
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property FormBuilder $form
     * @method BelongsTo|_IH_FormBuilder_QB form()
     * @method static _IH_ContactMessage_QB onWriteConnection()
     * @method _IH_ContactMessage_QB newQuery()
     * @method static _IH_ContactMessage_QB on(null|string $connection = null)
     * @method static _IH_ContactMessage_QB query()
     * @method static _IH_ContactMessage_QB with(array|string $relations)
     * @method _IH_ContactMessage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ContactMessage_C|ContactMessage[] all()
     * @ownLinks form_builder_id,\App\Models\FormBuilder,id
     * @mixin _IH_ContactMessage_QB
     */
    class ContactMessage extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $code
     * @property string|null $discount_amount
     * @property string|null $discount_type
     * @property int $max_use_qty
     * @property Carbon|null $expire_date
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Coupon_QB onWriteConnection()
     * @method _IH_Coupon_QB newQuery()
     * @method static _IH_Coupon_QB on(null|string $connection = null)
     * @method static _IH_Coupon_QB query()
     * @method static _IH_Coupon_QB with(array|string $relations)
     * @method _IH_Coupon_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Coupon_C|Coupon[] all()
     * @foreignLinks id,\App\Models\PaymentLogs,coupon_id|id,\App\Models\CouponLog,coupon_id|id,\App\Models\PaymentLogHistory,coupon_id
     * @mixin _IH_Coupon_QB
     */
    class Coupon extends Model {}
    
    /**
     * @property int $id
     * @property int|null $log_id
     * @property int|null $coupon_id
     * @property int|null $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_CouponLog_QB onWriteConnection()
     * @method _IH_CouponLog_QB newQuery()
     * @method static _IH_CouponLog_QB on(null|string $connection = null)
     * @method static _IH_CouponLog_QB query()
     * @method static _IH_CouponLog_QB with(array|string $relations)
     * @method _IH_CouponLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CouponLog_C|CouponLog[] all()
     * @ownLinks coupon_id,\App\Models\Coupon,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_CouponLog_QB
     */
    class CouponLog extends Model {}
    
    /**
     * @property int $id
     * @property int|null $cronjob_id
     * @property string|null $title
     * @property string|null $type
     * @property string|null $running_qty
     * @property string|null $others
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_CronjobLog_QB onWriteConnection()
     * @method _IH_CronjobLog_QB newQuery()
     * @method static _IH_CronjobLog_QB on(null|string $connection = null)
     * @method static _IH_CronjobLog_QB query()
     * @method static _IH_CronjobLog_QB with(array|string $relations)
     * @method _IH_CronjobLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CronjobLog_C|CronjobLog[] all()
     * @mixin _IH_CronjobLog_QB
     */
    class CronjobLog extends Model {}
    
    /**
     * @property int $id
     * @property int|null $user_id
     * @property string|null $custom_domain
     * @property string|null $custom_domain_status
     * @property string|null $old_domain
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $unique_key
     * @property-read mixed[] $translations attribute
     * @property Tenant|null $tenant
     * @method BelongsTo|_IH_Tenant_QB tenant()
     * @property _IH_Tenant_C|Tenant[] $tenants
     * @property-read int $tenants_count
     * @method BelongsToMany|_IH_Tenant_QB tenants()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_CustomDomain_QB onWriteConnection()
     * @method _IH_CustomDomain_QB newQuery()
     * @method static _IH_CustomDomain_QB on(null|string $connection = null)
     * @method static _IH_CustomDomain_QB query()
     * @method static _IH_CustomDomain_QB with(array|string $relations)
     * @method _IH_CustomDomain_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CustomDomain_C|CustomDomain[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_CustomDomain_QB
     */
    class CustomDomain extends Model {}
    
    /**
     * @property int $id
     * @property int $category_id
     * @property string $title
     * @property string $description
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property FaqCategory $category
     * @method BelongsTo|_IH_FaqCategory_QB category()
     * @method static _IH_Faq_QB onWriteConnection()
     * @method _IH_Faq_QB newQuery()
     * @method static _IH_Faq_QB on(null|string $connection = null)
     * @method static _IH_Faq_QB query()
     * @method static _IH_Faq_QB with(array|string $relations)
     * @method _IH_Faq_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Faq_C|Faq[] all()
     * @ownLinks category_id,\Modules\Attributes\Entities\Category,id
     * @mixin _IH_Faq_QB
     */
    class Faq extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @method static _IH_FaqCategory_QB onWriteConnection()
     * @method _IH_FaqCategory_QB newQuery()
     * @method static _IH_FaqCategory_QB on(null|string $connection = null)
     * @method static _IH_FaqCategory_QB query()
     * @method static _IH_FaqCategory_QB with(array|string $relations)
     * @method _IH_FaqCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FaqCategory_C|FaqCategory[] all()
     * @mixin _IH_FaqCategory_QB
     */
    class FaqCategory extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $email
     * @property string|null $button_text
     * @property string|null $fields
     * @property string|null $success_message
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @method static _IH_FormBuilder_QB onWriteConnection()
     * @method _IH_FormBuilder_QB newQuery()
     * @method static _IH_FormBuilder_QB on(null|string $connection = null)
     * @method static _IH_FormBuilder_QB query()
     * @method static _IH_FormBuilder_QB with(array|string $relations)
     * @method _IH_FormBuilder_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FormBuilder_C|FormBuilder[] all()
     * @foreignLinks id,\App\Models\ContactMessage,form_builder_id
     * @mixin _IH_FormBuilder_QB
     */
    class FormBuilder extends Model {}
    
    /**
     * @property int $id
     * @property int $category_id
     * @property string $title
     * @property string|null $subtitle
     * @property string $image
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property ImageGalleryCategory $category
     * @method BelongsTo|_IH_ImageGalleryCategory_QB category()
     * @method static _IH_ImageGallery_QB onWriteConnection()
     * @method _IH_ImageGallery_QB newQuery()
     * @method static _IH_ImageGallery_QB on(null|string $connection = null)
     * @method static _IH_ImageGallery_QB query()
     * @method static _IH_ImageGallery_QB with(array|string $relations)
     * @method _IH_ImageGallery_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ImageGallery_C|ImageGallery[] all()
     * @ownLinks category_id,\Modules\Attributes\Entities\Category,id
     * @mixin _IH_ImageGallery_QB
     */
    class ImageGallery extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @method static _IH_ImageGalleryCategory_QB onWriteConnection()
     * @method _IH_ImageGalleryCategory_QB newQuery()
     * @method static _IH_ImageGalleryCategory_QB on(null|string $connection = null)
     * @method static _IH_ImageGalleryCategory_QB query()
     * @method static _IH_ImageGalleryCategory_QB with(array|string $relations)
     * @method _IH_ImageGalleryCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ImageGalleryCategory_C|ImageGalleryCategory[] all()
     * @mixin _IH_ImageGalleryCategory_QB
     */
    class ImageGalleryCategory extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $slug
     * @property int $direction
     * @property int $status
     * @property int $default
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Language_QB onWriteConnection()
     * @method _IH_Language_QB newQuery()
     * @method static _IH_Language_QB on(null|string $connection = null)
     * @method static _IH_Language_QB query()
     * @method static _IH_Language_QB with(array|string $relations)
     * @method _IH_Language_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Language_C|Language[] all()
     * @mixin _IH_Language_QB
     */
    class Language extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $path
     * @property string|null $alt
     * @property string|null $size
     * @property int $user_type
     * @property int $user_id
     * @property string|null $dimensions
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_MediaUploader_QB onWriteConnection()
     * @method _IH_MediaUploader_QB newQuery()
     * @method static _IH_MediaUploader_QB on(null|string $connection = null)
     * @method static _IH_MediaUploader_QB query()
     * @method static _IH_MediaUploader_QB with(array|string $relations)
     * @method _IH_MediaUploader_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MediaUploader_C|MediaUploader[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_MediaUploader_QB
     */
    class MediaUploader extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $content
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Menu_QB onWriteConnection()
     * @method _IH_Menu_QB newQuery()
     * @method static _IH_Menu_QB on(null|string $connection = null)
     * @method static _IH_Menu_QB query()
     * @method static _IH_Menu_QB with(array|string $relations)
     * @method _IH_Menu_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Menu_C|Menu[] all()
     * @mixin _IH_Menu_QB
     */
    class Menu extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $description
     * @property string|null $image
     * @property string|null $fb_title
     * @property string|null $fb_description
     * @property string|null $fb_image
     * @property string|null $tw_title
     * @property string|null $tw_description
     * @property string|null $tw_image
     * @property int $metainfoable_id
     * @property string $metainfoable_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property Model $metainfoable
     * @method MorphTo metainfoable()
     * @method static _IH_MetaInfo_QB onWriteConnection()
     * @method _IH_MetaInfo_QB newQuery()
     * @method static _IH_MetaInfo_QB on(null|string $connection = null)
     * @method static _IH_MetaInfo_QB query()
     * @method static _IH_MetaInfo_QB with(array|string $relations)
     * @method _IH_MetaInfo_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MetaInfo_C|MetaInfo[] all()
     * @mixin _IH_MetaInfo_QB
     */
    class MetaInfo extends Model {}
    
    /**
     * @property int $id
     * @property string $email
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $token
     * @property string|null $verified
     * @method static _IH_Newsletter_QB onWriteConnection()
     * @method _IH_Newsletter_QB newQuery()
     * @method static _IH_Newsletter_QB on(null|string $connection = null)
     * @method static _IH_Newsletter_QB query()
     * @method static _IH_Newsletter_QB with(array|string $relations)
     * @method _IH_Newsletter_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Newsletter_C|Newsletter[] all()
     * @mixin _IH_Newsletter_QB
     */
    class Newsletter extends Model {}
    
    /**
     * @property int $id
     * @property int|null $notification_id
     * @property string|null $title
     * @property string|null $type
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property CustomDomain|null $custom_domain
     * @method BelongsTo|_IH_CustomDomain_QB custom_domain()
     * @property Newsletter|null $newsletter
     * @method BelongsTo|_IH_Newsletter_QB newsletter()
     * @property PaymentLogs|null $payment_log
     * @method BelongsTo|_IH_PaymentLogs_QB payment_log()
     * @property SupportTicket|null $support_ticket
     * @method BelongsTo|_IH_SupportTicket_QB support_ticket()
     * @property SupportTicketMessage|null $support_ticket_message
     * @method BelongsTo|_IH_SupportTicketMessage_QB support_ticket_message()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @property WalletHistory|null $wallet
     * @method BelongsTo|_IH_WalletHistory_QB wallet()
     * @method static _IH_Notification_QB onWriteConnection()
     * @method _IH_Notification_QB newQuery()
     * @method static _IH_Notification_QB on(null|string $connection = null)
     * @method static _IH_Notification_QB query()
     * @method static _IH_Notification_QB with(array|string $relations)
     * @method _IH_Notification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Notification_C|Notification[] all()
     * @mixin _IH_Notification_QB
     */
    class Notification extends Model {}
    
    /**
     * @property int $id
     * @property int|null $user_id
     * @property string|null $checkout_type
     * @property string $status
     * @property string $payment_status
     * @property string|null $package_id
     * @property string|null $package_name
     * @property string|null $package_price
     * @property string|null $custom_fields
     * @property string|null $attachment
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property PricePlan|null $package
     * @method HasOne|_IH_PricePlan_QB package()
     * @property PaymentLogs $paymentlog
     * @method HasOne|_IH_PaymentLogs_QB paymentlog()
     * @property User|null $user
     * @method HasOne|_IH_User_QB user()
     * @method static _IH_Order_QB onWriteConnection()
     * @method _IH_Order_QB newQuery()
     * @method static _IH_Order_QB on(null|string $connection = null)
     * @method static _IH_Order_QB query()
     * @method static _IH_Order_QB with(array|string $relations)
     * @method _IH_Order_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Order_C|Order[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_Order_QB
     */
    class Order extends Model {}
    
    /**
     * @property int $id
     * @property string $tenant_domain
     * @property int $user_id
     * @property int $payment_log_id
     * @property bool $trial_status
     * @property int $trial_qty
     * @property bool $zero_price_status
     * @property int $zero_package_qty
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PackageHistory_QB onWriteConnection()
     * @method _IH_PackageHistory_QB newQuery()
     * @method static _IH_PackageHistory_QB on(null|string $connection = null)
     * @method static _IH_PackageHistory_QB query()
     * @method static _IH_PackageHistory_QB with(array|string $relations)
     * @method _IH_PackageHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PackageHistory_C|PackageHistory[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|payment_log_id,\App\Models\PaymentLogs,id
     * @mixin _IH_PackageHistory_QB
     */
    class PackageHistory extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $slug
     * @property string|null $page_content
     * @property int $visibility
     * @property int $breadcrumb
     * @property int $page_builder
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property MetaInfo $metainfo
     * @method MorphToMany|_IH_MetaInfo_QB metainfo()
     * @method static _IH_Page_QB onWriteConnection()
     * @method _IH_Page_QB newQuery()
     * @method static _IH_Page_QB on(null|string $connection = null)
     * @method static _IH_Page_QB query()
     * @method static _IH_Page_QB with(array|string $relations)
     * @method _IH_Page_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Page_C|Page[] all()
     * @mixin _IH_Page_QB
     */
    class Page extends Model {}
    
    /**
     * @property int $id
     * @property string|null $addon_name
     * @property string|null $addon_type
     * @property string|null $addon_location
     * @property int|null $addon_order
     * @property int|null $addon_page_id
     * @property string|null $addon_page_type
     * @property string|null $addon_settings
     * @property string|null $addon_namespace
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PageBuilder_QB onWriteConnection()
     * @method _IH_PageBuilder_QB newQuery()
     * @method static _IH_PageBuilder_QB on(null|string $connection = null)
     * @method static _IH_PageBuilder_QB query()
     * @method static _IH_PageBuilder_QB with(array|string $relations)
     * @method _IH_PageBuilder_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PageBuilder_C|PageBuilder[] all()
     * @mixin _IH_PageBuilder_QB
     */
    class PageBuilder extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $image
     * @property string|null $description
     * @property int $status
     * @property int $test_mode
     * @property string $credentials
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PaymentGateway_QB onWriteConnection()
     * @method _IH_PaymentGateway_QB newQuery()
     * @method static _IH_PaymentGateway_QB on(null|string $connection = null)
     * @method static _IH_PaymentGateway_QB query()
     * @method static _IH_PaymentGateway_QB with(array|string $relations)
     * @method _IH_PaymentGateway_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PaymentGateway_C|PaymentGateway[] all()
     * @mixin _IH_PaymentGateway_QB
     */
    class PaymentGateway extends Model {}
    
    /**
     * @property int $id
     * @property int|null $package_id
     * @property int|null $user_id
     * @property int|null $coupon_id
     * @property float|null $coupon_discount
     * @property string|null $name
     * @property string|null $email
     * @property string|null $package_name
     * @property float|null $package_price
     * @property string|null $package_gateway
     * @property string|null $status
     * @property string|null $payment_status
     * @property string|null $transaction_id
     * @property string|null $manual_payment_attachment
     * @property string|null $track
     * @property int|null $is_renew
     * @property int|null $renew_status
     * @property int|null $assign_status
     * @property string|null $theme
     * @property string|null $start_date
     * @property string|null $expire_date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $tenant_id
     * @property PricePlan|null $package
     * @method BelongsTo|_IH_PricePlan_QB package()
     * @method static _IH_PaymentLogHistory_QB onWriteConnection()
     * @method _IH_PaymentLogHistory_QB newQuery()
     * @method static _IH_PaymentLogHistory_QB on(null|string $connection = null)
     * @method static _IH_PaymentLogHistory_QB query()
     * @method static _IH_PaymentLogHistory_QB with(array|string $relations)
     * @method _IH_PaymentLogHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PaymentLogHistory_C|PaymentLogHistory[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|coupon_id,\App\Models\Coupon,id|tenant_id,\Stancl\Tenancy\Database\Models\Tenant,id
     * @mixin _IH_PaymentLogHistory_QB
     */
    class PaymentLogHistory extends Model {}
    
    /**
     * @property int $id
     * @property string|null $email
     * @property string|null $name
     * @property string|null $package_name
     * @property string|null $package_price
     * @property string|null $package_gateway
     * @property string|null $package_id
     * @property int|null $user_id
     * @property string|null $status
     * @property string|null $payment_status
     * @property string|null $transaction_id
     * @property string|null $attachments
     * @property string|null $custom_fields
     * @property string|null $track
     * @property string|null $renew_status
     * @property string|null $theme
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $start_date
     * @property Carbon|null $expire_date
     * @property int|null $is_renew
     * @property string|null $tenant_id
     * @property string|null $trial_expire_date
     * @property string|null $manual_payment_attachment
     * @property string|null $unique_key
     * @property int|null $coupon_id
     * @property float|null $coupon_discount
     * @property bool $assign_status
     * @property string|null $theme_code
     * @property PricePlan|null $package
     * @method BelongsTo|_IH_PricePlan_QB package()
     * @property _IH_PricePlan_C|PricePlan[] $price_plan
     * @property-read int $price_plan_count
     * @method HasMany|_IH_PricePlan_QB price_plan()
     * @property Tenant|null $tenant
     * @method BelongsTo|_IH_Tenant_QB tenant()
     * @property _IH_Tenant_C|Tenant[] $tenants
     * @property-read int $tenants_count
     * @method BelongsToMany|_IH_Tenant_QB tenants()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_PaymentLogs_QB onWriteConnection()
     * @method _IH_PaymentLogs_QB newQuery()
     * @method static _IH_PaymentLogs_QB on(null|string $connection = null)
     * @method static _IH_PaymentLogs_QB query()
     * @method static _IH_PaymentLogs_QB with(array|string $relations)
     * @method _IH_PaymentLogs_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PaymentLogs_C|PaymentLogs[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|tenant_id,\Stancl\Tenancy\Database\Models\Tenant,id|coupon_id,\App\Models\Coupon,id
     * @foreignLinks id,\App\Models\PackageHistory,payment_log_id
     * @mixin _IH_PaymentLogs_QB
     */
    class PaymentLogs extends Model {}
    
    /**
     * @property int $id
     * @property int $plan_id
     * @property string $feature_name
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property PricePlan $plan
     * @method BelongsTo|_IH_PricePlan_QB plan()
     * @method static _IH_PlanFeature_QB onWriteConnection()
     * @method _IH_PlanFeature_QB newQuery()
     * @method static _IH_PlanFeature_QB on(null|string $connection = null)
     * @method static _IH_PlanFeature_QB query()
     * @method static _IH_PlanFeature_QB with(array|string $relations)
     * @method _IH_PlanFeature_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PlanFeature_C|PlanFeature[] all()
     * @mixin _IH_PlanFeature_QB
     */
    class PlanFeature extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $subtitle
     * @property int|null $type
     * @property int $status
     * @property float $price
     * @property string|null $faq
     * @property int|null $blog_permission_feature
     * @property int|null $page_permission_feature
     * @property bool $has_trial
     * @property int|null $trial_days
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $service_permission_feature
     * @property int|null $donation_permission_feature
     * @property int|null $job_permission_feature
     * @property int|null $event_permission_feature
     * @property int|null $knowledgebase_permission_feature
     * @property int|null $product_create_permission
     * @property int|null $campaign_create_permission
     * @property string|null $zero_price
     * @property int|null $storage_permission_feature
     * @property-read mixed[] $translations attribute
     * @property PlanFeature $plan_feature
     * @method HasOne|_IH_PlanFeature_QB plan_feature()
     * @property _IH_PlanFeature_C|PlanFeature[] $plan_features
     * @property-read int $plan_features_count
     * @method HasMany|_IH_PlanFeature_QB plan_features()
     * @method static _IH_PricePlan_QB onWriteConnection()
     * @method _IH_PricePlan_QB newQuery()
     * @method static _IH_PricePlan_QB on(null|string $connection = null)
     * @method static _IH_PricePlan_QB query()
     * @method static _IH_PricePlan_QB with(array|string $relations)
     * @method _IH_PricePlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PricePlan_C|PricePlan[] all()
     * @mixin _IH_PricePlan_QB
     */
    class PricePlan extends Model {}
    
    /**
     * @property int $id
     * @property string $option_name
     * @property string|null $option_value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_StaticOption_QB onWriteConnection()
     * @method _IH_StaticOption_QB newQuery()
     * @method static _IH_StaticOption_QB on(null|string $connection = null)
     * @method static _IH_StaticOption_QB query()
     * @method static _IH_StaticOption_QB with(array|string $relations)
     * @method _IH_StaticOption_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StaticOption_C|StaticOption[] all()
     * @mixin _IH_StaticOption_QB
     */
    class StaticOption extends Model {}
    
    /**
     * @property int $id
     * @property string $option_name
     * @property string|null $option_value
     * @property string|null $unique_key
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Tenant_C|Tenant[] $tenants
     * @property-read int $tenants_count
     * @method BelongsToMany|_IH_Tenant_QB tenants()
     * @method static _IH_StaticOptionCentral_QB onWriteConnection()
     * @method _IH_StaticOptionCentral_QB newQuery()
     * @method static _IH_StaticOptionCentral_QB on(null|string $connection = null)
     * @method static _IH_StaticOptionCentral_QB query()
     * @method static _IH_StaticOptionCentral_QB with(array|string $relations)
     * @method _IH_StaticOptionCentral_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StaticOptionCentral_C|StaticOptionCentral[] all()
     * @mixin _IH_StaticOptionCentral_QB
     */
    class StaticOptionCentral extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $deleted_at
     * @method static _IH_Status_QB onWriteConnection()
     * @method _IH_Status_QB newQuery()
     * @method static _IH_Status_QB on(null|string $connection = null)
     * @method static _IH_Status_QB query()
     * @method static _IH_Status_QB with(array|string $relations)
     * @method _IH_Status_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Status_C|Status[] all()
     * @foreignLinks id,\Modules\Product\Entities\Product,status_id|id,\Modules\Attributes\Entities\Category,status_id|id,\Modules\Attributes\Entities\SubCategory,status_id|id,\Modules\Attributes\Entities\ChildCategory,status_id
     * @mixin _IH_Status_QB
     */
    class Status extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @method static _IH_SupportDepartment_QB onWriteConnection()
     * @method _IH_SupportDepartment_QB newQuery()
     * @method static _IH_SupportDepartment_QB on(null|string $connection = null)
     * @method static _IH_SupportDepartment_QB query()
     * @method static _IH_SupportDepartment_QB with(array|string $relations)
     * @method _IH_SupportDepartment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportDepartment_C|SupportDepartment[] all()
     * @mixin _IH_SupportDepartment_QB
     */
    class SupportDepartment extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $via
     * @property string|null $operating_system
     * @property string|null $user_agent
     * @property string|null $description
     * @property string|null $subject
     * @property string|null $status
     * @property string|null $priority
     * @property int|null $department_id
     * @property int|null $user_id
     * @property int|null $admin_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Admin|null $admin
     * @method BelongsTo|_IH_Admin_QB admin()
     * @property SupportDepartment|null $department
     * @method BelongsTo|_IH_SupportDepartment_QB department()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_SupportTicket_QB onWriteConnection()
     * @method _IH_SupportTicket_QB newQuery()
     * @method static _IH_SupportTicket_QB on(null|string $connection = null)
     * @method static _IH_SupportTicket_QB query()
     * @method static _IH_SupportTicket_QB with(array|string $relations)
     * @method _IH_SupportTicket_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportTicket_C|SupportTicket[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|admin_id,\App\Models\Admin,id
     * @foreignLinks id,\App\Models\SupportTicketMessage,support_ticket_id
     * @mixin _IH_SupportTicket_QB
     */
    class SupportTicket extends Model {}
    
    /**
     * @property int $id
     * @property string|null $message
     * @property string|null $notify
     * @property string|null $attachment
     * @property string|null $type
     * @property int|null $user_id
     * @property int|null $support_ticket_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SupportTicketMessage_QB onWriteConnection()
     * @method _IH_SupportTicketMessage_QB newQuery()
     * @method static _IH_SupportTicketMessage_QB on(null|string $connection = null)
     * @method static _IH_SupportTicketMessage_QB query()
     * @method static _IH_SupportTicketMessage_QB with(array|string $relations)
     * @method _IH_SupportTicketMessage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SupportTicketMessage_C|SupportTicketMessage[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|support_ticket_id,\App\Models\SupportTicket,id
     * @mixin _IH_SupportTicketMessage_QB
     */
    class SupportTicketMessage extends Model {}
    
    /**
     * @property string $id
     * @property int $renew_status
     * @property int $is_renew
     * @property string|null $start_date
     * @property string|null $expire_date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property array|null $data
     * @property int|null $user_id
     * @property string|null $theme_slug
     * @property string|null $unique_key
     * @property CustomDomain $custom_domain
     * @method HasOne|_IH_CustomDomain_QB custom_domain()
     * @property UserDomain $domain
     * @method HasOne|_IH_UserDomain_QB domain()
     * @property _IH_Domain_C|Domain[] $domains
     * @property-read int $domains_count
     * @method HasMany|_IH_Domain_QB domains()
     * @property TenantException $issue
     * @method HasOne|_IH_TenantException_QB issue()
     * @property PaymentLogs $payment_log
     * @method HasOne|_IH_PaymentLogs_QB payment_log()
     * @property PaymentLogs $payment_log_for_sidebar
     * @method HasOne|_IH_PaymentLogs_QB payment_log_for_sidebar()
     * @property PaymentLogHistory $payment_log_history
     * @method HasOne|_IH_PaymentLogHistory_QB payment_log_history()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Tenant_QB onWriteConnection()
     * @method _IH_Tenant_QB newQuery()
     * @method static _IH_Tenant_QB on(null|string $connection = null)
     * @method static _IH_Tenant_QB query()
     * @method static _IH_Tenant_QB with(array|string $relations)
     * @method _IH_Tenant_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Tenant_C|Tenant[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @foreignLinks id,\Stancl\Tenancy\Database\Models\Domain,tenant_id|id,\App\Models\PaymentLogs,tenant_id|id,\App\Models\TenantException,tenant_id|id,\Modules\Wallet\Entities\WalletTenantList,tenant_id|id,\App\Models\PaymentLogHistory,tenant_id
     * @mixin _IH_Tenant_QB
     */
    class Tenant extends Model {}
    
    /**
     * @property _IH_Tenant_C|Tenant[] $tenants
     * @property-read int $tenants_count
     * @method BelongsToMany|_IH_Tenant_QB tenants()
     * @method static _IH_TenantActivityLog_QB onWriteConnection()
     * @method _IH_TenantActivityLog_QB newQuery()
     * @method static _IH_TenantActivityLog_QB on(null|string $connection = null)
     * @method static _IH_TenantActivityLog_QB query()
     * @method static _IH_TenantActivityLog_QB with(array|string $relations)
     * @method _IH_TenantActivityLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TenantActivityLog_C|TenantActivityLog[] all()
     * @mixin _IH_TenantActivityLog_QB
     */
    class TenantActivityLog extends Model {}
    
    /**
     * @property int $id
     * @property string $tenant_id
     * @property string|null $issue_type
     * @property string|null $description
     * @property int $domain_create_status
     * @property bool $seen_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Tenant $tenant
     * @method BelongsTo|_IH_Tenant_QB tenant()
     * @method static _IH_TenantException_QB onWriteConnection()
     * @method _IH_TenantException_QB newQuery()
     * @method static _IH_TenantException_QB on(null|string $connection = null)
     * @method static _IH_TenantException_QB query()
     * @method static _IH_TenantException_QB with(array|string $relations)
     * @method _IH_TenantException_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TenantException_C|TenantException[] all()
     * @ownLinks tenant_id,\Stancl\Tenancy\Database\Models\Tenant,id
     * @mixin _IH_TenantException_QB
     */
    class TenantException extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $designation
     * @property string $description
     * @property string|null $image
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $company
     * @property-read mixed[] $translations attribute
     * @method static _IH_Testimonial_QB onWriteConnection()
     * @method _IH_Testimonial_QB newQuery()
     * @method static _IH_Testimonial_QB on(null|string $connection = null)
     * @method static _IH_Testimonial_QB query()
     * @method static _IH_Testimonial_QB with(array|string $relations)
     * @method _IH_Testimonial_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Testimonial_C|Testimonial[] all()
     * @mixin _IH_Testimonial_QB
     */
    class Testimonial extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string $slug
     * @property string|null $description
     * @property bool $status
     * @property int|null $is_available
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $image
     * @property string|null $url
     * @property string|null $theme_code
     * @property-read mixed[] $translations attribute
     * @property _IH_Tenant_C|Tenant[] $tenants
     * @property-read int $tenants_count
     * @method BelongsToMany|_IH_Tenant_QB tenants()
     * @method static _IH_Themes_QB onWriteConnection()
     * @method _IH_Themes_QB newQuery()
     * @method static _IH_Themes_QB on(null|string $connection = null)
     * @method static _IH_Themes_QB query()
     * @method static _IH_Themes_QB with(array|string $relations)
     * @method _IH_Themes_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Themes_C|Themes[] all()
     * @mixin _IH_Themes_QB
     */
    class Themes extends Model {}
    
    /**
     * @property int $id
     * @property string|null $icon
     * @property string|null $url
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_TopbarInfo_QB onWriteConnection()
     * @method _IH_TopbarInfo_QB newQuery()
     * @method static _IH_TopbarInfo_QB on(null|string $connection = null)
     * @method static _IH_TopbarInfo_QB query()
     * @method static _IH_TopbarInfo_QB with(array|string $relations)
     * @method _IH_TopbarInfo_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TopbarInfo_C|TopbarInfo[] all()
     * @mixin _IH_TopbarInfo_QB
     */
    class TopbarInfo extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property string $password
     * @property string|null $remember_token
     * @property string $username
     * @property bool $has_subdomain
     * @property int $email_verified
     * @property string|null $email_verify_token
     * @property string|null $mobile
     * @property string|null $company
     * @property string|null $address
     * @property string|null $city
     * @property string|null $state
     * @property string|null $country
     * @property string|null $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $api_token_plan_text
     * @property string|null $temp_password
     * @property string|null $facebook_id
     * @property string|null $google_id
     * @property Country|null $country_name
     * @method BelongsTo|_IH_Country_QB country_name()
     * @property _IH_UserDomain_C|UserDomain[] $domains
     * @property-read int $domains_count
     * @method HasMany|_IH_UserDomain_QB domains()
     * @property LoginSecurity $loginSecurity
     * @method HasOne|_IH_LoginSecurity_QB loginSecurity()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_PaymentLogs_C|PaymentLogs[] $payment_log
     * @property-read int $payment_log_count
     * @method HasMany|_IH_PaymentLogs_QB payment_log()
     * @property PaymentLogs $payment_single_log
     * @method HasOne|_IH_PaymentLogs_QB payment_single_log()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Tenant_C|Tenant[] $tenant_details
     * @property-read int $tenant_details_count
     * @method HasMany|_IH_Tenant_QB tenant_details()
     * @property Tenant $tenant_info
     * @method BelongsTo|_IH_Tenant_QB tenant_info()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @property Wallet $wallet
     * @method HasOne|_IH_Wallet_QB wallet()
     * @property _IH_WalletTenantList_C|WalletTenantList[] $wallet_tenant_list
     * @property-read int $wallet_tenant_list_count
     * @method HasMany|_IH_WalletTenantList_QB wallet_tenant_list()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @foreignLinks id,\Modules\Product\Entities\UserDeliveryAddress,user_id|id,\Modules\Donation\Entities\DonationPaymentLog,user_id|id,\Modules\Event\Entities\EventPaymentLog,user_id|id,\Modules\Job\Entities\JobPaymentLog,user_id|id,\App\Models\WeddingPaymentLog,user_id|id,\Stancl\Tenancy\Database\Models\Tenant,user_id|id,\App\Models\Order,user_id|id,\App\Models\PaymentLogs,user_id|id,\App\Models\SupportTicket,user_id|id,\App\Models\SupportTicketMessage,user_id|id,\Modules\ShippingModule\Entities\ShippingAddress,user_id|id,\Modules\ShippingModule\Entities\UserShippingAddress,user_id|id,\Modules\Blog\Entities\BlogComment,user_id|id,\Modules\Donation\Entities\DonationComment,user_id|id,\App\Models\MediaUploader,user_id|id,\Modules\Blog\Entities\Blog,user_id|id,\App\Models\CustomDomain,user_id|id,\Modules\TwoFactorAuthentication\Entities\LoginSecurity,user_id|id,\Modules\Product\Entities\ProductOrder,user_id|id,\Modules\Event\Entities\EventComment,user_id|id,\Modules\Wallet\Entities\Wallet,user_id|id,\Modules\Wallet\Entities\WalletHistory,user_id|id,\Modules\Wallet\Entities\WalletSettings,user_id|id,\Modules\Wallet\Entities\WalletTenantList,user_id|id,\App\Models\PackageHistory,user_id|id,\App\Models\CouponLog,user_id|id,\App\Models\PaymentLogHistory,user_id
     * @mixin _IH_User_QB
     * @method static UserFactory factory(array|callable|int|null $count = null, array|callable $state = [])
     */
    class User extends Model {}
    
    /**
     * @property int $id
     * @property string $domain
     * @property string $tenant_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserDomain_QB onWriteConnection()
     * @method _IH_UserDomain_QB newQuery()
     * @method static _IH_UserDomain_QB on(null|string $connection = null)
     * @method static _IH_UserDomain_QB query()
     * @method static _IH_UserDomain_QB with(array|string $relations)
     * @method _IH_UserDomain_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserDomain_C|UserDomain[] all()
     * @ownLinks tenant_id,\Stancl\Tenancy\Database\Models\Tenant,id
     * @mixin _IH_UserDomain_QB
     */
    class UserDomain extends Model {}
    
    /**
     * @property int $id
     * @property int $package_id
     * @property int $user_id
     * @property string $name
     * @property string $email
     * @property string $package_name
     * @property float $package_price
     * @property string $package_gateway
     * @property string $status
     * @property string $payment_status
     * @property string $transaction_id
     * @property string $track
     * @property string|null $manual_payment_attachment
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property WeddingPricePlan $package
     * @method BelongsTo|_IH_WeddingPricePlan_QB package()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_WeddingPaymentLog_QB onWriteConnection()
     * @method _IH_WeddingPaymentLog_QB newQuery()
     * @method static _IH_WeddingPaymentLog_QB on(null|string $connection = null)
     * @method static _IH_WeddingPaymentLog_QB query()
     * @method static _IH_WeddingPaymentLog_QB with(array|string $relations)
     * @method _IH_WeddingPaymentLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_WeddingPaymentLog_C|WeddingPaymentLog[] all()
     * @ownLinks package_id,\App\Models\WeddingPricePlan,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_WeddingPaymentLog_QB
     */
    class WeddingPaymentLog extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $features
     * @property float $price
     * @property string|null $is_popular
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $not_available_features
     * @property-read mixed[] $translations attribute
     * @method static _IH_WeddingPricePlan_QB onWriteConnection()
     * @method _IH_WeddingPricePlan_QB newQuery()
     * @method static _IH_WeddingPricePlan_QB on(null|string $connection = null)
     * @method static _IH_WeddingPricePlan_QB query()
     * @method static _IH_WeddingPricePlan_QB with(array|string $relations)
     * @method _IH_WeddingPricePlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_WeddingPricePlan_C|WeddingPricePlan[] all()
     * @foreignLinks id,\App\Models\WeddingPaymentLog,package_id
     * @mixin _IH_WeddingPricePlan_QB
     */
    class WeddingPricePlan extends Model {}
    
    /**
     * @property int $id
     * @property string|null $widget_area
     * @property int|null $widget_order
     * @property string|null $widget_location
     * @property string $widget_name
     * @property string $widget_content
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Widgets_QB onWriteConnection()
     * @method _IH_Widgets_QB newQuery()
     * @method static _IH_Widgets_QB on(null|string $connection = null)
     * @method static _IH_Widgets_QB query()
     * @method static _IH_Widgets_QB with(array|string $relations)
     * @method _IH_Widgets_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Widgets_C|Widgets[] all()
     * @mixin _IH_Widgets_QB
     */
    class Widgets extends Model {}
}