<?php //a54a214d42e23f60386f6cb68280d31b
/** @noinspection all */

namespace Modules\Job\Entities {

    use App\Models\MetaInfo;
    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_MetaInfo_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Job\Entities\_IH_JobCategory_C;
    use LaravelIdea\Helper\Modules\Job\Entities\_IH_JobCategory_QB;
    use LaravelIdea\Helper\Modules\Job\Entities\_IH_JobPaymentLog_C;
    use LaravelIdea\Helper\Modules\Job\Entities\_IH_JobPaymentLog_QB;
    use LaravelIdea\Helper\Modules\Job\Entities\_IH_Job_C;
    use LaravelIdea\Helper\Modules\Job\Entities\_IH_Job_QB;
    
    /**
     * @property int $id
     * @property int $category_id
     * @property string $title
     * @property string|null $slug
     * @property string $description
     * @property string $experience
     * @property string $designation
     * @property string $employee_type
     * @property string $working_days
     * @property string $working_type
     * @property string $job_location
     * @property string $company_name
     * @property float $salary_offer
     * @property string|null $image
     * @property string $deadline
     * @property string|null $application_fee_status
     * @property int|null $application_fee
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property JobCategory $category
     * @method BelongsTo|_IH_JobCategory_QB category()
     * @property MetaInfo $metainfo
     * @method MorphToMany|_IH_MetaInfo_QB metainfo()
     * @method static _IH_Job_QB onWriteConnection()
     * @method _IH_Job_QB newQuery()
     * @method static _IH_Job_QB on(null|string $connection = null)
     * @method static _IH_Job_QB query()
     * @method static _IH_Job_QB with(array|string $relations)
     * @method _IH_Job_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Job_C|Job[] all()
     * @ownLinks category_id,\Modules\Attributes\Entities\Category,id
     * @foreignLinks id,\Modules\Job\Entities\JobPaymentLog,job_id
     * @mixin _IH_Job_QB
     */
    class Job extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $subtitle
     * @property string|null $image
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @method static _IH_JobCategory_QB onWriteConnection()
     * @method _IH_JobCategory_QB newQuery()
     * @method static _IH_JobCategory_QB on(null|string $connection = null)
     * @method static _IH_JobCategory_QB query()
     * @method static _IH_JobCategory_QB with(array|string $relations)
     * @method _IH_JobCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobCategory_C|JobCategory[] all()
     * @mixin _IH_JobCategory_QB
     */
    class JobCategory extends Model {}
    
    /**
     * @property int $id
     * @property int $job_id
     * @property int|null $user_id
     * @property string $name
     * @property string $email
     * @property string $phone
     * @property float|null $amount
     * @property string|null $payment_gateway
     * @property string|null $transaction_id
     * @property string|null $track
     * @property string|null $manual_payment_attachment
     * @property string|null $resume
     * @property string|null $comment
     * @property bool $status
     * @property bool $payable_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Job $job
     * @method BelongsTo|_IH_Job_QB job()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_JobPaymentLog_QB onWriteConnection()
     * @method _IH_JobPaymentLog_QB newQuery()
     * @method static _IH_JobPaymentLog_QB on(null|string $connection = null)
     * @method static _IH_JobPaymentLog_QB query()
     * @method static _IH_JobPaymentLog_QB with(array|string $relations)
     * @method _IH_JobPaymentLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_JobPaymentLog_C|JobPaymentLog[] all()
     * @ownLinks job_id,\Modules\Job\Entities\Job,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_JobPaymentLog_QB
     */
    class JobPaymentLog extends Model {}
}