<?php //f95ed8abdeb049aa5654630ebb0ea81c
/** @noinspection all */

namespace Modules\Donation\Entities {

    use App\Models\MetaInfo;
    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_MetaInfo_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Donation\Entities\_IH_DonationActivityCategory_C;
    use LaravelIdea\Helper\Modules\Donation\Entities\_IH_DonationActivityCategory_QB;
    use LaravelIdea\Helper\Modules\Donation\Entities\_IH_DonationActivity_C;
    use LaravelIdea\Helper\Modules\Donation\Entities\_IH_DonationActivity_QB;
    use LaravelIdea\Helper\Modules\Donation\Entities\_IH_DonationCategory_C;
    use LaravelIdea\Helper\Modules\Donation\Entities\_IH_DonationCategory_QB;
    use LaravelIdea\Helper\Modules\Donation\Entities\_IH_DonationComment_C;
    use LaravelIdea\Helper\Modules\Donation\Entities\_IH_DonationComment_QB;
    use LaravelIdea\Helper\Modules\Donation\Entities\_IH_DonationPaymentLog_C;
    use LaravelIdea\Helper\Modules\Donation\Entities\_IH_DonationPaymentLog_QB;
    use LaravelIdea\Helper\Modules\Donation\Entities\_IH_Donation_C;
    use LaravelIdea\Helper\Modules\Donation\Entities\_IH_Donation_QB;
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $description
     * @property string $amount
     * @property string|null $raised
     * @property bool $status
     * @property string|null $image
     * @property string|null $image_gallery
     * @property string|null $slug
     * @property string|null $excerpt
     * @property int $creator_id
     * @property string|null $created_by
     * @property int $category_id
     * @property string|null $faq
     * @property string|null $deadline
     * @property string|null $popular
     * @property int $views
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property DonationCategory $category
     * @method BelongsTo|_IH_DonationCategory_QB category()
     * @property _IH_DonationComment_C|DonationComment[] $comments
     * @property-read int $comments_count
     * @method HasMany|_IH_DonationComment_QB comments()
     * @property MetaInfo $metainfo
     * @method MorphToMany|_IH_MetaInfo_QB metainfo()
     * @method static _IH_Donation_QB onWriteConnection()
     * @method _IH_Donation_QB newQuery()
     * @method static _IH_Donation_QB on(null|string $connection = null)
     * @method static _IH_Donation_QB query()
     * @method static _IH_Donation_QB with(array|string $relations)
     * @method _IH_Donation_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Donation_C|Donation[] all()
     * @ownLinks category_id,\Modules\Attributes\Entities\Category,id
     * @foreignLinks id,\Modules\Donation\Entities\DonationPaymentLog,donation_id|id,\Modules\Donation\Entities\DonationComment,donation_id
     * @mixin _IH_Donation_QB
     */
    class Donation extends Model {}
    
    /**
     * @property int $id
     * @property int $category_id
     * @property string $title
     * @property string|null $slug
     * @property string|null $description
     * @property bool $status
     * @property string|null $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property DonationActivityCategory $category
     * @method BelongsTo|_IH_DonationActivityCategory_QB category()
     * @property MetaInfo $metainfo
     * @method MorphToMany|_IH_MetaInfo_QB metainfo()
     * @method static _IH_DonationActivity_QB onWriteConnection()
     * @method _IH_DonationActivity_QB newQuery()
     * @method static _IH_DonationActivity_QB on(null|string $connection = null)
     * @method static _IH_DonationActivity_QB query()
     * @method static _IH_DonationActivity_QB with(array|string $relations)
     * @method _IH_DonationActivity_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DonationActivity_C|DonationActivity[] all()
     * @ownLinks category_id,\Modules\Attributes\Entities\Category,id
     * @mixin _IH_DonationActivity_QB
     */
    class DonationActivity extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $slug
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @method static _IH_DonationActivityCategory_QB onWriteConnection()
     * @method _IH_DonationActivityCategory_QB newQuery()
     * @method static _IH_DonationActivityCategory_QB on(null|string $connection = null)
     * @method static _IH_DonationActivityCategory_QB query()
     * @method static _IH_DonationActivityCategory_QB with(array|string $relations)
     * @method _IH_DonationActivityCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DonationActivityCategory_C|DonationActivityCategory[] all()
     * @mixin _IH_DonationActivityCategory_QB
     */
    class DonationActivityCategory extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $slug
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @method static _IH_DonationCategory_QB onWriteConnection()
     * @method _IH_DonationCategory_QB newQuery()
     * @method static _IH_DonationCategory_QB on(null|string $connection = null)
     * @method static _IH_DonationCategory_QB query()
     * @method static _IH_DonationCategory_QB with(array|string $relations)
     * @method _IH_DonationCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DonationCategory_C|DonationCategory[] all()
     * @mixin _IH_DonationCategory_QB
     */
    class DonationCategory extends Model {}
    
    /**
     * @property int $id
     * @property int $donation_id
     * @property int $user_id
     * @property string $commented_by
     * @property string $comment_content
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Donation $donation
     * @method BelongsTo|_IH_Donation_QB donation()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_DonationComment_QB onWriteConnection()
     * @method _IH_DonationComment_QB newQuery()
     * @method static _IH_DonationComment_QB on(null|string $connection = null)
     * @method static _IH_DonationComment_QB query()
     * @method static _IH_DonationComment_QB with(array|string $relations)
     * @method _IH_DonationComment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DonationComment_C|DonationComment[] all()
     * @ownLinks donation_id,\Modules\Donation\Entities\Donation,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_DonationComment_QB
     */
    class DonationComment extends Model {}
    
    /**
     * @property int $id
     * @property int $donation_id
     * @property int|null $user_id
     * @property string|null $transaction_id
     * @property string $name
     * @property string $email
     * @property float $amount
     * @property string|null $payment_gateway
     * @property string|null $track
     * @property string|null $manual_payment_attachment
     * @property bool $status
     * @property string|null $note
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Donation $donation
     * @method BelongsTo|_IH_Donation_QB donation()
     * @method static _IH_DonationPaymentLog_QB onWriteConnection()
     * @method _IH_DonationPaymentLog_QB newQuery()
     * @method static _IH_DonationPaymentLog_QB on(null|string $connection = null)
     * @method static _IH_DonationPaymentLog_QB query()
     * @method static _IH_DonationPaymentLog_QB with(array|string $relations)
     * @method _IH_DonationPaymentLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DonationPaymentLog_C|DonationPaymentLog[] all()
     * @ownLinks donation_id,\Modules\Donation\Entities\Donation,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_DonationPaymentLog_QB
     */
    class DonationPaymentLog extends Model {}
}