<?php //3e2551fd468f8e228f56169c8323cf4d
/** @noinspection all */

namespace Modules\Event\Entities {

    use App\Models\MetaInfo;
    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_MetaInfo_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Event\Entities\_IH_EventCategory_C;
    use LaravelIdea\Helper\Modules\Event\Entities\_IH_EventCategory_QB;
    use LaravelIdea\Helper\Modules\Event\Entities\_IH_EventComment_C;
    use LaravelIdea\Helper\Modules\Event\Entities\_IH_EventComment_QB;
    use LaravelIdea\Helper\Modules\Event\Entities\_IH_EventPaymentLog_C;
    use LaravelIdea\Helper\Modules\Event\Entities\_IH_EventPaymentLog_QB;
    use LaravelIdea\Helper\Modules\Event\Entities\_IH_Event_C;
    use LaravelIdea\Helper\Modules\Event\Entities\_IH_Event_QB;
    
    /**
     * @property int $id
     * @property int $category_id
     * @property string $title
     * @property string|null $slug
     * @property string $content
     * @property string $date
     * @property string $time
     * @property int $cost
     * @property int $total_ticket
     * @property int|null $available_ticket
     * @property string|null $image
     * @property string|null $organizer
     * @property string|null $organizer_email
     * @property string|null $organizer_phone
     * @property string|null $venue_location
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property EventCategory $category
     * @method BelongsTo|_IH_EventCategory_QB category()
     * @property _IH_EventComment_C|EventComment[] $comments
     * @property-read int $comments_count
     * @method HasMany|_IH_EventComment_QB comments()
     * @property MetaInfo $metainfo
     * @method MorphToMany|_IH_MetaInfo_QB metainfo()
     * @method static _IH_Event_QB onWriteConnection()
     * @method _IH_Event_QB newQuery()
     * @method static _IH_Event_QB on(null|string $connection = null)
     * @method static _IH_Event_QB query()
     * @method static _IH_Event_QB with(array|string $relations)
     * @method _IH_Event_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Event_C|Event[] all()
     * @ownLinks category_id,\Modules\Attributes\Entities\Category,id
     * @foreignLinks id,\Modules\Event\Entities\EventPaymentLog,event_id|id,\Modules\Event\Entities\EventComment,event_id
     * @mixin _IH_Event_QB
     */
    class Event extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @method static _IH_EventCategory_QB onWriteConnection()
     * @method _IH_EventCategory_QB newQuery()
     * @method static _IH_EventCategory_QB on(null|string $connection = null)
     * @method static _IH_EventCategory_QB query()
     * @method static _IH_EventCategory_QB with(array|string $relations)
     * @method _IH_EventCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EventCategory_C|EventCategory[] all()
     * @mixin _IH_EventCategory_QB
     */
    class EventCategory extends Model {}
    
    /**
     * @property int $id
     * @property int $event_id
     * @property int $user_id
     * @property string $commented_by
     * @property string $comment_content
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Event $event
     * @method BelongsTo|_IH_Event_QB event()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_EventComment_QB onWriteConnection()
     * @method _IH_EventComment_QB newQuery()
     * @method static _IH_EventComment_QB on(null|string $connection = null)
     * @method static _IH_EventComment_QB query()
     * @method static _IH_EventComment_QB with(array|string $relations)
     * @method _IH_EventComment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EventComment_C|EventComment[] all()
     * @ownLinks event_id,\Modules\Event\Entities\Event,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_EventComment_QB
     */
    class EventComment extends Model {}
    
    /**
     * @property int $id
     * @property int $event_id
     * @property int|null $user_id
     * @property string|null $transaction_id
     * @property string $name
     * @property string $email
     * @property string $phone
     * @property string|null $address
     * @property int $ticket_qty
     * @property float $amount
     * @property string|null $payment_gateway
     * @property string|null $track
     * @property string|null $manual_payment_attachment
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Event $event
     * @method BelongsTo|_IH_Event_QB event()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_EventPaymentLog_QB onWriteConnection()
     * @method _IH_EventPaymentLog_QB newQuery()
     * @method static _IH_EventPaymentLog_QB on(null|string $connection = null)
     * @method static _IH_EventPaymentLog_QB query()
     * @method static _IH_EventPaymentLog_QB with(array|string $relations)
     * @method _IH_EventPaymentLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EventPaymentLog_C|EventPaymentLog[] all()
     * @ownLinks event_id,\Modules\Event\Entities\Event,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_EventPaymentLog_QB
     */
    class EventPaymentLog extends Model {}
}