<?php $__env->startSection('title'); ?>
    <?php echo e(__('Wallet')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Wallet')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
    <style>
        .deposit-button{
            background-color: var(--main-color-one);
            border: var(--main-color-two);
            padding: 10px 10px;
        }
        .deposit-button:hover{
            background-color: var(--main-color-one);
            border: var(--main-color-one);
        }

        .deposit-button i{
            font-size: 23px;
            margin-right: 10px;
            vertical-align: text-bottom;
        }

        .confirm-bottom-content{
            margin-top: 30px;
        }
        .payment-gateway-wrapper ul{
            display: flex;
            flex-wrap: wrap;
        }
        .payment-gateway-wrapper li{
            display: flex;
            margin-left: 10px;
        }

        .payment-gateway-wrapper li.selected{
            border: 3px solid var(--main-color-two);
            border-radius: 5px;
        }
        .payment-gateway-wrapper li {
            width: calc(100%/4);
        }
        .payment-gateway-wrapper ul {
            display: flex;
            gap: 6px;
            flex-wrap: wrap;
            margin: 0;
            padding: 0;
            flex-basis: 100%;
            width: 100%;
            margin-left: 30px;
        }
        .deposit-table tbody tr td:nth-child(2), .deposit-table tbody tr td:nth-child(3){
            text-transform: capitalize;
        }

        .payment_attachment{
            width: 100px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('section'); ?>
    <!-- Dashboard area Starts -->
    <div class="single-orders">
        <div class="orders-flex-content">
            <div class="icon">
                <i class="las la-dollar-sign"></i>
            </div>
            <div class="contents">
                <h2 class="order-titles">
                    <?php if(empty($balance->balance)): ?>
                        <?php echo e(float_amount_with_currency_symbol(0.00)); ?>

                    <?php else: ?>
                        <?php echo e(float_amount_with_currency_symbol($balance->balance)); ?>

                    <?php endif; ?>
                </h2>
                <span class="order-para"><?php echo e(__('Wallet Balance')); ?> </span>
            </div>
        </div>
    </div>

    <div class="dashboard-settings margin-top-55 d-flex justify-content-between">
        <div>
            <h2 class="dashboards-title"><?php echo e(__('Wallet History')); ?> </h2>
            <div class="notice-board">
                <p class="text-primary"><?php echo e(__('You can deposit to your wallet from here.')); ?></p>
            </div>
        </div>

        <div class="dashboard-settings mt-4 text-end">
            <button type="button" class="btn btn-primary deposit-button" data-bs-toggle="modal"
                    data-bs-target="#payoutRequestModal"><i class="las la-wallet"></i> <?php echo e(__('Deposit To Your Wallet')); ?></button>
        </div>
    </div>

    <div class="single-dashboard-order mt-5">
        <div class="table-responsive table-responsive--md">
            <table class="custom--table deposit-table">
                <thead>
                <tr>
                    <th> <?php echo e(__('ID')); ?></th>
                    <th> <?php echo e(__('Payment Gateway')); ?> </th>
                    <th> <?php echo e(__('Payment Status')); ?> </th>
                    <th> <?php echo e(__('Deposit Amount')); ?> </th>
                    <th> <?php echo e(__('Deposit Date')); ?> </th>
                    <th> <?php echo e(__('Payment Image')); ?> </th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $wallet_histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="<?php echo e(__('ID')); ?>"><?php echo e($history->id); ?> </td>
                        <td data-label="<?php echo e(__('Payment Gateway')); ?>">
                            <?php
                                $payment_gateway = str_replace('_', ' ', $history->payment_gateway);
                            ?>
                            <?php echo e($payment_gateway); ?>

                        </td>
                        <td data-label="<?php echo e(__('Payment Status')); ?>"><?php echo e($history->payment_status); ?></td>
                        <td data-label="<?php echo e(__('Request Amount')); ?>"> <?php echo e(float_amount_with_currency_symbol($history->amount)); ?> </td>
                        <td data-label="<?php echo e(__('Request Date')); ?>"><?php echo e($history->created_at->diffForHumans()); ?> </td>
                        <td data-label="<?php echo e(__('Request Date')); ?>">
                            <?php if(empty($history->manual_payment_image)): ?>
                                <?php echo e(__('No Image')); ?>

                            <?php else: ?>
                                <img class="rounded payment_attachment"
                                     src="<?php echo e(asset('assets/landlord/uploads/deposit_payment_attachments/'.$history->manual_payment_image)); ?>"
                                     alt="payment-image">
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="blog-pagination margin-top-55">
            <div class="custom-pagination mt-4 mt-lg-5">
                <?php echo $wallet_histories->links(); ?>

            </div>
        </div>

    </div>



    <!--Status Modal -->
    <div class="modal fade" id="payoutRequestModal" tabindex="-1" role="dialog" aria-labelledby="editModal"
         aria-hidden="true">
        <form action="<?php echo e(route('landlord.user.wallet.deposit')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title text-primary"
                            id="couponModal"><?php echo e(__('You can deposit to your wallet from the available payment gateway.')); ?></h5>
                        <button type="button" class="close btn-danger" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <label for=""><?php echo e(__('Deposit Amount')); ?></label>
                        <input type="number" class="form-control mt-2" name="amount"
                               placeholder="<?php echo e(__('Enter Deposit Amount')); ?>">
                        <div class="confirm-bottom-content">
                            <div class="confirm-payment payment-border">
                                <div class="single-checkbox">
                                    <div class="checkbox-inlines">
                                        <label class="checkbox-label" for="check2">
                                            <?php echo render_payment_gateway_for_form(); ?>

                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('Submit Deposit')); ?></button>
                    </div>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/backend/js/sweetalert2.js')); ?>"></script>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.wallet-payment-gateway-js','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('wallet-payment-gateway-js'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
    <script>
        (function ($) {
            "use strict";

            $(document).ready(function () {
                $(document).on('click', '.edit_status_modal', function (e) {
                    e.preventDefault();
                    let order_id = $(this).data('id');
                    let status = $(this).data('status');

                    $('#order_id').val(order_id);
                    $('#status').val(status);
                    $('.nice-select').niceSelect('update');
                });

            });

        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('landlord.frontend.user.dashboard.user-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/multipurposesass/public_html/core/Modules/Wallet/Resources/views/frontend/buyer/wallet-history.blade.php ENDPATH**/ ?>