
<?php
    $margin_for_not_login_user = !auth()->guard('web')->check() ? 'mt-50' : '';
?>

<div class="row <?php echo e($margin_for_not_login_user); ?>">
    <div class="col-xl-12">
        <div class="section-tittle mb-30">
            <h2 class="tittle"><?php echo e(__('Related Blog')); ?></h2>
        </div>
    </div>

    <?php $__currentLoopData = $allRelatedBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-4 col-md-6 ">
            <figure class="singleBlog-global mb-24">
                <div class="blog-img overlay1">
                    <a href="<?php echo e(route(route_prefix().'frontend.blog.single',$data->slug)); ?>">
                        <?php echo render_image_markup_by_attachment_id($data->image); ?>

                    </a>
                    <div class="img-text">
                        <span class="content"><?php echo e($data->category?->getTranslation('title',get_user_lang())); ?></span>
                    </div>
                </div>
                <figcaption class="blogCaption">
                    <ul class="cartTop">
                        <li class="listItmes"><i class="fa-solid fa-calculator icon"></i><?php echo e($data->created_at?->format('d M Y')); ?></li>
                        <li class="listItmes"><i class="fa-solid fa-eye icon"></i> <?php echo e($data->views); ?></li>
                        <li class="listItmes"><i class="fa-solid fa-comment icon"></i> <?php echo e($data->comments?->count()); ?> <?php echo e(__('Comment')); ?></li>
                    </ul>
                    <h3><a href="<?php echo e(route(route_prefix().'frontend.blog.single',$data->slug)); ?>" class="tittle"><?php echo e($data->getTranslation('title',get_user_lang())); ?></a></h3>
                    <p class="pera mb-4"><?php echo \Illuminate\Support\Str::words(strip_tags($data->getTranslation('blog_content',get_user_lang())),40); ?></p>
                    <br>
                </figcaption>
            </figure>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


</div>
<?php /**PATH /home/multipurposesass/public_html/core/Modules/Blog/Resources/views/components/frontend/related-blog.blade.php ENDPATH**/ ?>