<?php if($notification_type == 'new_subscription'): ?>
    <tr>
        <td><?php echo e($notification->payment_log?->id); ?></td>
        <td>
            <ul>
                <li><?php echo e(__('User Name')); ?> : <span><?php echo e($notification->payment_log?->name); ?></span></li>
                <li><?php echo e(__('Package Name')); ?> : <span><?php echo e($notification->payment_log?->package_name); ?></span></li>
                <li><?php echo e(__('Amount')); ?> : <span><?php echo e(amount_with_currency_symbol($notification->payment_log?->package_price)); ?></span></li>
                <li><?php echo e(__('Domain')); ?> : <span><?php echo e($notification->payment_log?->tenant_id . '.'. env('CENTRAL_DOMAIN')); ?></span></li>
                <li><?php echo e(__('Start Date')); ?> : <span><?php echo e(date('d-m-Y',strtotime($notification->payment_log?->start_date))); ?></span></li>
                <li><?php echo e(__('Expire Date')); ?> : <span><?php echo e(date('d-m-Y',strtotime($notification->payment_log?->expire_date))); ?></span></li>
                <li><?php echo e(__('Payment Status ')); ?> : <span><?php echo e($notification->payment_log?->payment_status); ?></span></li>
            </ul>
        </td>
        <td>
            <span class="badge badge-info"><?php echo e(str_replace('_', ' ', ucfirst($notification_type))); ?></span>
        </td>
    </tr>
<?php endif; ?>

<?php if($notification_type == 'package_renew'): ?>
    <tr>
        <td><?php echo e($notification->payment_log?->id); ?></td>
        <td>
            <ul>
                <li><?php echo e(__('User Name')); ?> : <span><?php echo e($notification->payment_log?->name); ?></span></li>
                <li><?php echo e(__('Package Name')); ?> : <span><?php echo e($notification->payment_log?->package_name); ?></span></li>
                <li><?php echo e(__('Amount')); ?> : <span><?php echo e(amount_with_currency_symbol($notification->payment_log?->package_price)); ?></span></li>
                <li><?php echo e(__('Domain')); ?> : <span><?php echo e($notification->payment_log?->tenant_id . '.'. env('CENTRAL_DOMAIN')); ?></span></li>
                <li><?php echo e(__('Start Date')); ?> : <span><?php echo e(date('d-m-Y',strtotime($notification->payment_log?->start_date))); ?></span></li>
                <li><?php echo e(__('Expire Date')); ?> : <span><?php echo e(date('d-m-Y',strtotime($notification->payment_log?->expire_date))); ?></span></li>
                <li><?php echo e(__('Payment Status ')); ?> : <span><?php echo e($notification->payment_log?->payment_status); ?></span></li>
                <li><?php echo e(__('Renew taken')); ?> : <span><?php echo e($notification->payment_log?->renew_status); ?></span></li>
            </ul>
        </td>
        <td>
            <span class="badge badge-info"><?php echo e(str_replace('_', ' ', ucfirst($notification_type))); ?></span>
        </td>
    </tr>
<?php endif; ?>

<?php if($notification_type == 'trial'): ?>
    <tr>
        <td><?php echo e($notification->payment_log?->id); ?></td>
        <td>
            <ul>
                <li><?php echo e(__('User Name')); ?> : <span><?php echo e($notification->payment_log?->name); ?></span></li>
                <li><?php echo e(__('Package Name')); ?> : <span><?php echo e($notification->payment_log?->package_name); ?></span></li>
                <li><?php echo e(__('Amount')); ?> : <span><?php echo e(amount_with_currency_symbol($notification->payment_log?->package_price)); ?></span></li>
                <li><?php echo e(__('Domain')); ?> : <span><?php echo e($notification->payment_log?->tenant_id . '.'. env('CENTRAL_DOMAIN')); ?></span></li>
                <li><?php echo e(__('Start Date')); ?> : <span><?php echo e(date('d-m-Y',strtotime($notification->payment_log?->start_date))); ?></span></li>
                <li><?php echo e(__('Expire Date')); ?> : <span><?php echo e(date('d-m-Y',strtotime($notification->payment_log?->expire_date))); ?></span></li>
                <li><?php echo e(__('Order Status ')); ?> : <span><?php echo e($notification->payment_log?->status); ?></span></li>
                <li><?php echo e(__('Payment Status ')); ?> : <span><?php echo e($notification->payment_log?->payment_status); ?></span></li>
            </ul>
        </td>
        <td>
            <span class="badge badge-info"><?php echo e(str_replace('_', ' ', ucfirst($notification_type))); ?></span>
        </td>
    </tr>
<?php endif; ?>

<?php if($notification_type == 'support_ticket'): ?>
    <tr>
        <td><?php echo e($notification->support_ticket?->id); ?></td>
        <td>
            <ul>
                <li><?php echo e(__('Ticket ID')); ?> : <span><?php echo e($notification->support_ticket?->id); ?></span></li>
                <li><?php echo e(__('User Name')); ?> : <span><?php echo e($notification->support_ticket?->user?->name); ?></span></li>
                <li><?php echo e(__('Ticket Title')); ?> : <span><?php echo e($notification->support_ticket?->title); ?></span></li>
                <li><?php echo e(__('Ticket Subject')); ?> : <span><?php echo e($notification->support_ticket?->subject); ?></span></li>
                <li><?php echo e(__('Ticket Status')); ?> : <span><?php echo e($notification->support_ticket?->status); ?></span></li>
            </ul>
        </td>
        <td>
            <span class="badge badge-info"><?php echo e(str_replace('_', ' ', ucfirst($notification_type))); ?></span>
        </td>
    </tr>
<?php endif; ?>

<?php if($notification_type == 'support_ticket_message'): ?>
    <tr>
        <td><?php echo e($notification->support_ticket_message?->id); ?></td>
        <td>
            <ul>
                <li><?php echo e(__('Message ID')); ?> : <span><?php echo e($notification->support_ticket_message?->id); ?></span></li>
                <li><?php echo e(__('Message')); ?> : <span><?php echo $notification->support_ticket_message?->message; ?></span></li>
            </ul>
        </td>
        <td>
            <span class="badge badge-info"><?php echo e(str_replace('_', ' ', ucfirst($notification_type))); ?></span>
        </td>
    </tr>
<?php endif; ?>


<?php if($notification_type == 'newsletter_subscribed'): ?>
    <tr>
        <td><?php echo e($notification->newsletter?->id); ?></td>
        <td>
            <ul>
                <li><?php echo e(__('ID')); ?> : <span><?php echo e($notification->newsletter?->id); ?></span></li>
                <li><?php echo e(__('Email')); ?> : <span><?php echo $notification->newsletter?->email; ?></span></li>
                <li><?php echo e(__('Status')); ?> : <span> <?php echo e($notification->newsletter?->status == 1 ? __('Verified') : __('Not Verified')); ?></span></li>
            </ul>
        </td>
        <td>
            <span class="badge badge-info"><?php echo e(str_replace('_', ' ', ucfirst($notification_type))); ?></span>
        </td>
    </tr>
<?php endif; ?>



<?php if($notification_type == 'custom_domain_request'): ?>
    <tr>
        <td><?php echo e($notification->custom_domain?->id); ?></td>
        <td>
            <ul>
                <li><?php echo e(__('ID')); ?> : <span><?php echo e($notification->custom_domain?->id); ?></span></li>
                <li><?php echo e(__('Old Domain')); ?> : <span><?php echo $notification->custom_domain?->old_domain; ?></span></li>
                <li><?php echo e(__('New Domain')); ?> : <span><?php echo $notification->custom_domain?->custom_domain; ?></span></li>
            </ul>
        </td>
        <td>
            <span class="badge badge-info"><?php echo e(str_replace('_', ' ', ucfirst($notification_type))); ?></span>
        </td>
    </tr>
<?php endif; ?>

<?php if($notification_type == 'user_registration'): ?>
    <tr>
        <td><?php echo e($notification->user?->id); ?></td>
        <td>
            <ul>
                <li><?php echo e(__('ID')); ?> : <span><?php echo e($notification->user?->id); ?></span></li>
                <li><?php echo e(__('Name')); ?> : <span><?php echo $notification->user?->name; ?></span></li>
                <li><?php echo e(__('Email')); ?> : <span><?php echo $notification->user?->email; ?></span></li>
            </ul>
        </td>
        <td>
            <span class="badge badge-info"><?php echo e(str_replace('_', ' ', ucfirst($notification_type))); ?></span>
        </td>
    </tr>
<?php endif; ?>

<?php if($notification_type == 'wallet_deposit'): ?>
    <tr>
        <td><?php echo e($notification->id); ?></td>
        <td>
            <ul>
                <li><?php echo e(__('User Name')); ?> : <span><?php echo $notification->wallet?->user?->name; ?></span></li>
                <li><?php echo e(__('Amount')); ?> : <span><?php echo e(amount_with_currency_symbol($notification->wallet?->amount)); ?></span></li>
            </ul>
        </td>
        <td>
            <span class="badge badge-info"><?php echo e(str_replace('_', ' ', ucfirst($notification_type))); ?></span>
        </td>
    </tr>
<?php endif; ?>

<?php /**PATH /home/multipurposesass/public_html/core/resources/views/landlord/admin/notification/details-table-markup.blade.php ENDPATH**/ ?>