<?php $__env->startSection('title'); ?>
    <?php echo $campaign->title; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $campaign->title; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="productCampaign section-padding">
        <div class="container" >
            <h3 class=" mb-40"><?php echo e(__('Campaign')); ?> : <?php echo e($campaign->title); ?></h3>
       <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12">
        <div class="row all_product_container">
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $product = optional($pro->product);
                    $data = get_product_dynamic_price($product);
                    $campaign_name = $data['campaign_name'];
                    $regular_price = $data['regular_price'];
                    $sale_price = $data['sale_price'];
                    $discount = $data['discount'];
                ?>

                <div class="col-xl-3">
                    <div class="singleProduct mb-24">
                        <div class="productImg imgEffect2">
                            <a href="<?php echo e(route('tenant.shop.product.details',$product->slug)); ?>">
                                <?php echo render_image_markup_by_attachment_id($product->image_id); ?>

                            </a>

                            <div class="sticky-wrap">
                                <!-- sticker -->
                                <?php if(!empty($product->badge)): ?>
                                    <span class="sticky stickyStye ratedStock"><i class="fa-solid fa-medal icon"></i><?php echo e($product?->badge?->getTranslation('name',get_user_lang())); ?></span>
                                <?php endif; ?>

                                <?php if($product->inventory?->stock_count < 1): ?>
                                    <span class="sticky stickyStye outStock"><?php echo e(__('Out of stock')); ?></span>
                                <?php endif; ?>
                            </div>

                            <?php echo $__env->make('product::frontend.option-feature', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        </div>

                        <div class="productCap">

                            <h5>
                                <a href="<?php echo e(route('tenant.shop.product.details', $product->slug)); ?>" class="title"><?php echo e(Str::words($product->getTranslation('name',get_user_lang()), 4)); ?> </a>
                            </h5>

                            <?php echo render_product_star_rating_markup_with_count($product); ?>


                            <?php if($product->inventory?->stock_count > 0): ?>
                                <span class="quintity avilable"><?php echo e(__('In Stock')); ?> <span class="quintityNumber">(<?php echo e($product->inventory?->stock_count); ?>)</span> </span>
                            <?php else: ?>
                                <span class="quintity text-danger"><?php echo e(__('Stock Out')); ?> <span class="quintityNumber">(<?php echo e($product->inventory?->stock_count); ?>)</span> </span>
                            <?php endif; ?>


                            <div class="d-flex align-items-center flex-wrap justify-content-between">
                                <div class="productPrice">
                                    <?php echo product_prices($product, 'color-two'); ?>

                                </div>
                                <div class="btn-wrapper mb-15">
                                    <a href="#!" data-product_id="<?php echo e($product->id); ?>" class="cmn-btn-outline3 add-to-buy-now-btn"><?php echo e(__('Buy Now')); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    </div>
    </section>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('tenant.frontend.frontend-page-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/multipurposesass/public_html/core/resources/views/themes/construction/frontend/shop/campaign-details.blade.php ENDPATH**/ ?>