<?php $__env->startSection('title'); ?>
    <?php echo e(__('Wallet')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Wallet')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.frontend-switcher-css','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('frontend-switcher-css'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
    <style>
        label{
            text-transform: capitalize;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('section'); ?>

    <!-- Dashboard area Starts -->

    <div class="single-orders">
        <div class="orders-flex-content">
            <div class="icon">
                <i class="las la-dollar-sign"></i>
            </div>
            <div class="contents">
                <h2 class="order-titles">
                    <?php if(empty($balance->balance)): ?>
                        <?php echo e(float_amount_with_currency_symbol(0.00)); ?>

                    <?php else: ?>
                        <?php echo e(float_amount_with_currency_symbol($balance->balance)); ?>

                    <?php endif; ?>
                </h2>
                <span class="order-para"><?php echo e(__('Wallet Balance')); ?> </span>
            </div>
        </div>
    </div>

    <div class="dashboard-settings margin-top-55 d-flex justify-content-between">
        <div>
            <h2 class="dashboards-title"><?php echo e(__('Wallet Settings')); ?> </h2>
        </div>
    </div>

    <div class="single-dashboard-order mt-5">
        <div class="table-responsive table-responsive--md">
            <form action="<?php echo e(route('landlord.user.wallet.settings')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label><?php echo e(__('Enable/Disable Package Renewal')); ?></label>
                    <label class="switch ">
                        <input type="checkbox" name="renewal_using_wallet" <?php echo e(!empty($settings) && $settings->renew_package ? 'checked' : ''); ?>>
                        <span class="slider onff"></span>
                    </label>
                </div>

                <div class="form-group tenant_list">
                    <ul>
                        <?php
                            $user = Auth::guard('web')->user();

                            $user_tenants = [];
                            if (!empty($user->wallet_tenant_list))
                                {
                                    $user_tenants = $user->wallet_tenant_list->pluck('tenant_id')->toArray();
                                }

                            $tenant_list = $user?->tenant_details?->where('expire_date', '!=', null);
                        ?>
                        <?php $__currentLoopData = $tenant_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tenant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="my-3">
                                <input type="checkbox" name="tenants_list[]" id="<?php echo e($loop->iteration); ?>" class="exampleCheck1"
                                       value="<?php echo e($tenant->id); ?>" <?php echo e(in_array($tenant->id, $user_tenants) ? 'checked' : ''); ?>>
                                <label class="ml-1" for="<?php echo e($loop->iteration); ?>">
                                    <?php echo e($tenant->id); ?>

                                </label>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>

                <div class="form-group mt-3">
                    <label><?php echo e(__('Get wallet balance alert')); ?></label>
                    <label class="switch ">
                        <input type="checkbox" name="wallet_balance_alert" <?php echo e(!empty($settings) && $settings->wallet_alert ? 'checked' : ''); ?>>
                        <span class="slider onff"></span>
                    </label>
                </div>

                <div class="form-group minimum_alert_amount_wrapper">
                    <label for="name" class="label-title"><?php echo e(__('Alert for Minimum amount').' ('.site_currency_symbol().')'); ?></label>
                    <input type="text" class="form-control form--control" id="minimum_alert_amount" name="minimum_alert_amount" placeholder="Example 100" value="<?php echo e(!empty($settings) ? $settings->minimum_amount : ''); ?>"/>
                </div>

                <div class="form-group mt-3">
                    <button class="btn btn-primary" type="submit"><?php echo e(__('Submit')); ?></button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/backend/js/sweetalert2.js')); ?>"></script>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.wallet-payment-gateway-js','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('wallet-payment-gateway-js'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
    <script>
        (function ($) {
            "use strict";

            $(document).ready(function () {
                let tenant_list = $('.tenant_list');

                <?php if(!empty($settings) && !$settings->renew_package): ?>
                    tenant_list.hide();
                <?php endif; ?>


                let alert_minimum_amount = $('.minimum_alert_amount_wrapper');
                <?php if(!empty($settings) && !$settings->wallet_alert): ?>
                    alert_minimum_amount.hide();
                <?php endif; ?>

                $(document).on('click', 'input[name=renewal_using_wallet]', function (e) {
                    if ($(this).is(':checked'))
                    {
                        tenant_list.fadeIn();
                    } else {
                        tenant_list.fadeOut();
                        setTimeout(()=>{
                            tenant_list.find('input').removeAttr('checked');
                        }, 500)
                    }
                });

                $(document).on('click', 'input[name=wallet_balance_alert]', function (e) {
                    if ($(this).is(':checked'))
                    {
                        alert_minimum_amount.fadeIn();
                    } else {
                        alert_minimum_amount.fadeOut();
                        setTimeout(()=>{
                            alert_minimum_amount.find('input').val('');
                        }, 500)
                    }
                });
            });

        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('landlord.frontend.user.dashboard.user-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/multipurposesass/public_html/core/Modules/Wallet/Resources/views/frontend/buyer/wallet-settings.blade.php ENDPATH**/ ?>