<?php if(count($shipping_methods) > 0): ?>
    <ul class="coupon-contents-details-list coupon-border">
        <h6><?php echo e(__('Shipping')); ?></h6>
        <?php $__currentLoopData = $shipping_methods ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li class="coupon-contents-details-list-item" data-country="<?php echo e($country); ?>" data-state="<?php echo e($state); ?>">
                <span class="coupon-radio-item">
                    <input type="radio" id="shipping-option-<?php echo e($method['id']); ?>" value="<?php echo e($method['id']); ?>" name="shipping_method">
                    <label for="shipping-option-<?php echo e($method['id']); ?>">
                        <?php echo e($method['name']); ?>

                    </label>
                </span>
                <span><?php echo e(amount_with_currency_symbol($method['options']['cost'])); ?></span>
            </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>

<ul class="coupon-contents-details-list coupon-border">
    <li class="coupon-contents-details-list-item"><span> <?php echo e(__('Tax (Incl)')); ?> </span>
        <span> <?php echo e($product_tax ? $product_tax.'%' : '0%'); ?> </span>
    </li>
    <li class="coupon-contents-details-list-item"><span> <?php echo e(__('Coupon Discount (-)')); ?> </span>
        <span>
            <?php
                if (isset($coupon)) {
                    if ($coupon['discount_type'] == 'amount') {
                        $discount = site_currency_symbol().$coupon['discount'];
                    } else {
                        $discount = $coupon['discount'].'%';
                    }
                }
            ?>

            <?php echo e(isset($coupon) ? $discount : amount_with_currency_symbol(0.00)); ?>

        </span>
    </li>
    <li class="coupon-contents-details-list-item price-shipping">
        <span> <?php echo e(__('Shipping Cost (+)')); ?> </span>
        <span> -- </span>
    </li>
</ul>
<ul class="coupon-contents-details-list coupon-border">
    <?php
        $subtotal = Cart::subtotal(0,'','');
        $taxed_price = ($subtotal * $product_tax) / 100;
        $total = $subtotal + $taxed_price;
    ?>
    <li class="coupon-contents-details-list-item price-total" data-total="<?php echo e($total); ?>">
        <h6 class="coupon-title"> <?php echo e(__('Total Amount')); ?> </h6> <span
            class="coupon-price fw-500 color-heading"> <?php echo e(amount_with_currency_symbol($total)); ?> </span>
    </li>
</ul>
<?php /**PATH /home/multipurposesass/public_html/core/resources/views/themes/eCommerce/frontend/shop/checkout/markup_for_controller/shipping_tax_ajax.blade.php ENDPATH**/ ?>