
<section class="construction_testimonial_area padding-top-50 padding-bottom-50">
    <div class="container" data-padding-top="<?php echo e($data['padding_top']); ?>" data-padding-bottom="<?php echo e($data['padding_bottom']); ?>">
        <div class="constructionTestimonial construction-section-bg-2 radius-10">
            <div class="constructionTestimonial_wrapper__shapes">
                <img src="<?php echo e(global_asset('assets/tenant/frontend/themes/img/construction/testimonial/construction_shape.png')); ?>" alt="">
            </div>
            <div class="constructionTestimonial__shapes">
                <img src="<?php echo e(global_asset('assets/tenant/frontend/themes/img/construction/testimonial/construction_feedback.png')); ?>" alt="feedback">
                <img src="<?php echo e(global_asset('assets/tenant/frontend/themes/img/construction/testimonial/construction_review.png')); ?>" alt="review">
            </div>
            <?php
                $heading_type_con = $data['heading_style'] == 'consultancy' ? 'consulting_sectionTitle'  : 'construction_sectionTitle__two'
            ?>

            <div class="<?php echo e($heading_type_con); ?>">

                <?php if($data['heading_style'] == 'consultancy'): ?>
                    <span class="subtitle"><?php echo e($data['title']); ?></span>
                    <?php echo get_consultancy_subtitle_line_breaker($data['subtitle']); ?>

                <?php else: ?>
                    <h2 class="title"><?php echo e($data['title']); ?></h2>
                <?php endif; ?>
            </div>
            <div class="row g-4 mt-4 justify-content-between align-items-center">
                <div class="col-lg-12">
                    <div class="hoverCustom_tab constructionTestimonial_wrapper">
                        <div class="hoverCustom_tab__menu">
                            <ul class="hoverTab__menu constructionTestimonial_wrapper__images list-style-none">
                                <?php $__currentLoopData = $data['testimonial'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="constructionTestimonial_wrapper__images__single <?php echo e($loop->index == 0 ? 'active' : ''); ?>" data-id="<?php echo e($item->id); ?>">
                                        <?php echo render_image_markup_by_attachment_id($item->image); ?>

                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <div class="row justify-content-center">
                            <div class="col-xxl-5 col-lg-6 col-md-8">
                                <div class="hoverTab_area testimonial_inner_single">
                                    <?php $__currentLoopData = $data['testimonial'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_bottom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($loop->index == 1) break; ?>
                                        <div class="construction__singleTestimonial hoverTab_item active center-text">
                                            <div class="construction__singleTestimonial__thumb">
                                                <?php echo render_image_markup_by_attachment_id($item_bottom->image); ?>

                                                <span class="construction__singleTestimonial__thumb__quote"><i class="fa-solid fa-quote-left"></i></span>
                                            </div>
                                            <div class="construction__singleTestimonial__contents mt-5">
                                                <div class="construction__singleTestimonial__contents__details">
                                                    <h4 class="construction__singleTestimonial__contents__title"><?php echo e($item_bottom->name); ?></h4>
                                                    <span class="construction__singleTestimonial__contents__subtitle mt-1"><?php echo e($item_bottom->designation); ?></span>
                                                    <div class="construction__singleTestimonial__contents__star mt-2">
                                                        <span><i class="fa-solid fa-star"></i></span>
                                                        <span><i class="fa-solid fa-star"></i></span>
                                                        <span><i class="fa-solid fa-star"></i></span>
                                                        <span><i class="fa-solid fa-star"></i></span>
                                                        <span><i class="fa-solid fa-star"></i></span>
                                                    </div>
                                                </div>
                                                <p class="construction__singleTestimonial__contents__para mt-4 mt-lg-5"><?php echo \Illuminate\Support\Str::words($item_bottom->getTranslation('description',get_user_lang()),30); ?></p>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<?php $__env->startSection('scripts'); ?>
    <script>
        $(function (){

            $(document).on('mouseover', '.constructionTestimonial_wrapper__images__single', function (e){
                e.preventDefault();

                let el = $(this);
                let testimonial_id = el.data('id');

                $.ajax({
                    type: 'GET',
                    url: "<?php echo e(route('tenant.frontend.home.construction.testimonial.by.ajax')); ?>",
                    data: {
                        id : testimonial_id,
                    },
                    success: function (data){
                        $('.testimonial_inner_single').html(data);
                    },
                    error: function (data){
                    }
                });

            });

        });
    </script>
<?php $__env->stopSection(); ?>


<?php /**PATH /Users/xgenious/Desktop/xgenious/localhost/multisaas-update/core/plugins/PageBuilder/views/tenant/construction/testimonial-area.blade.php ENDPATH**/ ?>