
<!DOCTYPE html>
<html lang="<?php echo e(\App\Facades\GlobalLanguage::user_lang_slug()); ?>" dir="<?php echo e(\App\Facades\GlobalLanguage::user_lang_dir()); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <?php echo SEOMeta::generate(); ?>

    <?php echo OpenGraph::generate(); ?>

    <?php echo Twitter::generate(); ?>

    <?php echo JsonLd::generate(); ?>


    
       <?php echo $__env->make('tenant.frontend.partials.font-manage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

    <?php echo render_favicon_by_id(get_static_option('site_favicon')); ?>


    <title>
        <?php if(!request()->routeIs('tenant.frontend.homepage')): ?>
            <?php echo $__env->yieldContent('title'); ?>
            -
            <?php echo e(filter_static_option_value('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_title',$global_static_field_data)); ?>

        <?php else: ?>
            <?php echo e(filter_static_option_value('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_title',$global_static_field_data)); ?>

            <?php if(!empty(filter_static_option_value('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_tag_line',$global_static_field_data))): ?>
                - <?php echo e(filter_static_option_value('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_tag_line',$global_static_field_data)); ?>

            <?php endif; ?>
        <?php endif; ?>
    </title>


    <?php echo render_favicon_by_id(filter_static_option_value('site_favicon', $global_static_field_data)); ?>


    <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/themes/css/bootstrap.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/themes/css/plugin.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(global_asset('assets/common/css/toastr.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/themes/css/odometer.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/themes/css/developer.css')); ?>">

    <?php if(!empty(tenant()->id)): ?>
        <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/themes/css/dynamic-styles/'.tenant()->id.'-style.css')); ?>">
    <?php endif; ?>

    <link rel="stylesheet" href="<?php echo e(global_asset('assets/landlord/common/css/helpers.css')); ?>">
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.frontend.common-css','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('frontend.common-css'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
    <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/themes/css/'.get_static_option('tenant_default_theme').'-main-style.css')); ?>">

    <?php if(\App\Facades\GlobalLanguage::user_lang_dir() == 'rtl'): ?>
        <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/themes/css/'.get_static_option('tenant_default_theme').'-rtl.css')); ?>">
    <?php endif; ?>

    <?php echo $__env->make('tenant.frontend.partials.css-variable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loaders.custom-loader','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('loaders.custom-loader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
    <?php echo $__env->yieldContent('style'); ?>

</head>


<body class="<?php echo e(tenant()?->payment_log?->theme); ?>">

<?php echo $__env->make('tenant.frontend.partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php /**PATH /Users/xgenious/Desktop/xgenious/localhost/multisaas-update/core/resources/views/tenant/frontend/partials/header.blade.php ENDPATH**/ ?>