<?php
    $end_date = !empty($data["campaign"]->end_date) ? $data["campaign"]->end_date : '';
    $button_text = $data['button_text'];
?>

<section class="productCampaign section-padding">
    <div class="container" data-padding-top="<?php echo e($data['padding_top']); ?>" data-padding-bottom="<?php echo e($data['padding_bottom']); ?>">
        <div class="row mb-40">
            <div class="col-xl-6 col-lg-12 col-md-10 col-sm-10">
                <div class="section-tittle mb-0">
                    <h2 class="title"><?php echo e($data['title']); ?> </h2>
                </div>
            </div>
            <div class="col-xl-6 col-lg-12 col-md-10 col-sm-10">
                <div class="d-flex align-items-center flex-wrap float-xl-end">
                    <div class="small-tittle mb-10 mr-10">
                        <h2 class="tittle"><?php echo e($data['campaign_right_title']); ?></h2>
                    </div>
                    <!-- Timer -->
                    <div class="dateTimmerGlobal wow fadeInRight flash-countdown" data-date="<?php echo e($end_date); ?>"  data-wow-delay="0.0s">
                        <div class="donation_countdown">
                            <div class="single">
                                <div class="cap">
                                    <span class="time counter-days"></span>
                                    <p class="cap"><?php echo e(__('Days')); ?></p>
                                </div>
                            </div>
                            <div class="single">
                                <span class="time counter-hours"></span>
                                <p class="cap"><?php echo e(__('Hours')); ?></p>
                            </div>
                            <div class="single">
                                <span class="time counter-minutes"></span>
                                <p class="cap"><?php echo e(__('Mins')); ?></p>
                            </div>
                            <div class="single">
                                <span class="time counter-seconds"></span>
                                <p class="cap"><?php echo e(__('Secs')); ?></p>
                            </div>
                        </div>
                    </div>
                    <!-- /E n d -->
                </div>
            </div>
        </div>
        <div class="row">
            <?php $__currentLoopData = $data["products"]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $product = optional($pro->product);
                ?>
                <?php
                    $data = get_product_dynamic_price($product);
                    $campaign_name = $data['campaign_name'];
                    $regular_price = $data['regular_price'];
                    $sale_price = $data['sale_price'];
                    $discount = $data['discount'];

                    $url = !empty($product->slug) ? route('tenant.shop.product.details',$product->slug) : '';
                    $image = render_image_markup_by_attachment_id($product->image_id)
                ?>
                <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                    <div class="singleProduct text-center mb-24">
                        <div class="productImg imgEffect2">

                            <a href="<?php echo e($url); ?>">
                                <?php echo $image; ?>

                            </a>

                            <div class="sticky-wrap">
                                <?php if(!empty($product->badge)): ?>
                                    <span class="sticky stickyStye "><?php echo e($product?->badge?->name); ?></span>
                                <?php endif; ?>

                                <?php if($product->inventory?->stock_count < 1): ?>
                                    <span class="sticky stickyStye outStock"><?php echo e(__('Out of stock')); ?></span>
                                <?php endif; ?>
                            </div>
                            <?php echo $__env->make('product::frontend.option-feature', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="productCap">
                            <h5><a href="<?php echo e(!empty($product->slug) ?route('tenant.shop.product.details',$product->slug) : ''); ?>" class="title"><?php echo e($product->name); ?></a></h5>
                            <?php echo render_product_star_rating_markup_with_count($product); ?>


                            <?php if($product->inventory?->stock_count > 0): ?>
                                <span class="quintity avilable"><?php echo e(__('In Stock')); ?> <span class="quintityNumber">(<?php echo e($product->inventory?->stock_count); ?>)</span> </span>
                            <?php else: ?>
                                <span class="quintity text-danger"><?php echo e(__('Stock Out')); ?> <span class="quintityNumber">(<?php echo e($product->inventory?->stock_count); ?>)</span> </span>
                            <?php endif; ?>
                            <div class="productPrice">
                                <strong class="regularPrice"><?php echo e($regular_price != null ? amount_with_currency_symbol( $regular_price) : ''); ?></strong>
                                <span class="offerPrice"><?php echo e(amount_with_currency_symbol($sale_price)); ?></span>
                            </div>
                            <div class="btn-wrapper">
                                <?php if(count($product->inventoryDetail ?? []) > 0 ): ?>
                                    <a href="<?php echo e(route('tenant.shop.product.details',$product->slug)); ?>" class="cmn-btn-outline3 w-100"><?php echo e(__('View')); ?></a>
                                <?php else: ?>
                                    <a href="#!" data-product_id="<?php echo e($product->id); ?>" class="cmn-btn-outline3 w-100 add-to-buy-now-btn"><?php echo e($button_text); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>


<?php /**PATH /home/multipurposesass/public_html/core/plugins/PageBuilder/views/tenant/eCommerce/product-campaigns.blade.php ENDPATH**/ ?>