<?php
    $left_blog = $data['left_blog'];
    $blogs = $data['blogs'];
?>


<section class="newspaper_sports_area  padding-top-50 padding-bottom-50">
    <div class="container" data-padding-top="<?php echo e($data['padding_top']); ?>" data-padding-bottom="<?php echo e($data['padding_bottom']); ?>">
        <div class="row g-4">
            <div class="col-lg-9">
                <div class="newspaper_section__title border__bottom text-left title_flex">
                    <h4 class="title"><?php echo e($data['title']); ?></h4>
                    <a href="<?php echo e($data['view_more_url']); ?>" class="viewMore_btn"><?php echo e(__('View More')); ?> <i class="las la-arrow-right"></i></a>
                </div>
                <div class="row g-4 mt-1">
                    <div class="col-md-8">
                        <div class="newspaper_sports newspaper_sports_bg">
                            <div class="newspaper_sports__thumb">
                                <a href="<?php echo e(route('tenant.frontend.blog.single',$left_blog->slug)); ?>">
                                    <?php echo render_image_markup_by_attachment_id($left_blog->image); ?>

                                </a>
                            </div>
                            <div class="newspaper_sports__contents pt-4">
                                <div class="newspaper_sports__tag">
                                    <a href="javascript:void(0)" class="newspaper_sports__tag__item">
                                        <div class="newspaper_sports__tag__item__thumb">
                                            <img src="<?php echo e(global_asset('assets/tenant/frontend/themes/img/newspaper/latest/newspaper_author1.jpg')); ?>" alt="authorImg">
                                        </div>
                                        <span class="newspaper_sports__tag__item__title"><?php echo e($left_blog->author); ?></span>
                                    </a>
                                    <a href="javascript:void(0)" class="newspaper_sports__tag__item">
                                        <div class="newspaper_sports__tag__item__icon"><i class="las la-clock"></i></div>
                                        <span class="newspaper_sports__tag__item__title"><?php echo e(date('d M Y',strtotime($left_blog->created_at))); ?></span>
                                    </a>
                                    <a href="javascript:void(0)" class="newspaper_sports__tag__item">
                                        <div class="newspaper_sports__tag__item__icon"><i class="las la-comments"></i></div>
                                        <span class="newspaper_sports__tag__item__title"><?php echo e($left_blog->comments?->count()); ?></span>
                                    </a>
                                </div>
                                <h4 class="newspaper_sports__title style-02 mt-3"><a href="javascript:void(0)"><?php echo e($left_blog->title); ?></a></h4>
                                <p class="newspaper_sports__para style-02 mt-3">
                                <?php echo $left_blog->excerpt ?? $strip_tags(\Illuminate\Support\Str::words($left_blog->blog_content,35)); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="row g-4">
                            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <?php
                                    $comment_count = $data->comments?->count();
                                ?>
                                <div class="newspaper_latest__item">
                                    <div class="newspaper_latest newspaper_latest_bg">
                                        <div class="newspaper_latest__thumb">
                                            <a href="<?php echo e(route('tenant.frontend.blog.single',$data->slug)); ?>">
                                                <?php echo render_image_markup_by_attachment_id($data->image); ?>

                                            </a>
                                        </div>
                                        <div class="newspaper_latest__contents pt-3">
                                            <h4 class="newspaper_latest__title">
                                                <a href="<?php echo e(route('tenant.frontend.blog.single',$data->slug)); ?>"><?php echo e($data->title); ?></a>
                                            </h4>
                                            <div class="newspaper_latest__tag mt-2">
                                                <a href="<?php echo e(route('tenant.frontend.blog.single',$data->slug)); ?>" class="newspaper_latest__tag__item">
                                                    <div class="newspaper_latest__tag__item__thumb">
                                                        <img src="<?php echo e(global_asset('assets/tenant/frontend/themes/img/newspaper/latest/newspaper_author1.jpg')); ?>" alt="authorImg">
                                                    </div>
                                                    <span class="newspaper_latest__tag__item__title"><?php echo e($data->author); ?></span>
                                                </a>
                                                <a href="<?php echo e(route('tenant.frontend.blog.single',$data->slug)); ?>" class="newspaper_latest__tag__item">
                                                    <div class="newspaper_latest__tag__item__icon"><i class="las la-clock"></i></div>
                                                    <span class="newspaper_latest__tag__item__title"><?php echo e(date('d M Y',strtotime($data->created_at))); ?></span>
                                                </a>
                                                <a href="<?php echo e(route('tenant.frontend.blog.single',$data->slug)); ?>" class="newspaper_latest__tag__item">
                                                    <div class="newspaper_latest__tag__item__icon"><i class="las la-comments"></i></div>
                                                    <span class="newspaper_latest__tag__item__title"><?php echo e($comment_count); ?></span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="newspaper_sideWidget">
                    <div class="newspaper_section__title style-02 border__bottom text-left">
                        <h4 class="title"><?php echo e(__('Stay Connected')); ?></h4>
                    </div>
                    <div class="newspaper_sideWidget__inner mt-4">
                        <?php echo render_frontend_sidebar('newspaper_sidebar',['column'=>false]); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/multipurposesass/public_html/core/plugins/PageBuilder/views/tenant/newspaper/sports-area.blade.php ENDPATH**/ ?>