
<!DOCTYPE html>
<html lang="<?php echo e(\App\Facades\GlobalLanguage::user_lang_slug()); ?>" dir="<?php echo e(\App\Facades\GlobalLanguage::user_lang_dir()); ?>">

<head>

    <?php echo get_static_option('site_google_analytics'); ?>


    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">


    <?php if(request()->is('home') || request()->is('/')): ?>
        <meta property="title" content="<?php echo e(get_static_option('site_'.get_user_lang().'_meta_title')); ?>" />
        <meta property="tags" content="<?php echo e(get_static_option('site_'.get_user_lang().'_meta_tags')); ?>" />
        <meta property="keywords" content="<?php echo e(get_static_option('site_'.get_user_lang().'_meta_keywords')); ?>" />
        <meta property="description" content="<?php echo e(get_static_option('site_'.get_user_lang().'_meta_description')); ?>" />

        <?php
            $og_meta_image = get_attachment_image_by_id(get_static_option('site_'.get_user_lang().'_og_meta_image'));
        ?>
        <meta property="og:title" content="<?php echo e(get_static_option('site_'.get_user_lang().'_og_meta_title')); ?>" />
        <meta property="og:description" content="<?php echo e(get_static_option('site_'.get_user_lang().'_og_meta_description')); ?>" />
        <meta property="og:image" content="<?php echo e($og_meta_image['img_url'] ?? ''); ?>" />
    <?php endif; ?>

    <?php if(Route::currentRouteName() === 'tenant.dynamic.page'): ?>
        <?php echo render_page_meta_data($page_post); ?>

    <?php else: ?>
        <?php echo $__env->yieldContent('meta-data'); ?>
    <?php endif; ?>

    <?php echo SEOMeta::generate(); ?>

    <?php echo JsonLd::generate(); ?>



    <?php
        $theme_slug = getSelectedThemeSlug();
        $theme_header_css_files = \App\Facades\ThemeDataFacade::getHeaderHookCssFiles();
        $theme_header_js_files = \App\Facades\ThemeDataFacade::getHeaderHookJsFiles();
        $theme_header_rtl_css = \App\Facades\ThemeDataFacade::getHeaderHookRtlCssFiles();
    ?>

    
       <?php echo $__env->make('tenant.frontend.partials.font-manage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

    <?php echo render_favicon_by_id(get_static_option('site_favicon')); ?>



    <title>
        <?php if(!request()->routeIs('tenant.frontend.homepage')): ?>
            <?php if(Route::currentRouteName() === 'tenant.dynamic.page'): ?>
                <?php
                    $dynamic_page_title = $page_post->getTranslation('title',get_user_lang());
                    $static_page_meta_data = $page_post->metainfo?->getTranslation('title',get_user_lang());
                    $condition_other_dynamic_pages = !empty($static_page_meta_data) ? $static_page_meta_data : $dynamic_page_title;
                ?>
                <?php echo e($condition_other_dynamic_pages); ?>

            <?php else: ?>
                <?php echo $__env->yieldContent('title'); ?>
            <?php endif; ?>
            -
            <?php echo e(filter_static_option_value('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_title',$global_static_field_data)); ?>

        <?php else: ?>

            <?php
                $site_meta_tittle = !empty($page_post) ? $page_post->metainfo?->getTranslation('title',get_user_lang()) : '';
                $site_page_tittle = !empty($page_post) ? $page_post->getTranslation('title',get_user_lang()) : '';
                $condition_meta_title = !empty($site_meta_tittle) ? $site_meta_tittle : $site_page_tittle;
            ?>

            <?php echo e(!empty($condition_meta_title) ? $condition_meta_title : filter_static_option_value('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_title',$global_static_field_data)); ?>


            <?php if(!empty(filter_static_option_value('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_tag_line',$global_static_field_data))): ?>
                - <?php echo e(filter_static_option_value('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_tag_line',$global_static_field_data)); ?>

            <?php endif; ?>
        <?php endif; ?>
    </title>


    <?php echo render_favicon_by_id(filter_static_option_value('site_favicon', $global_static_field_data)); ?>


    <?php if(loadCoreStyle()): ?>
    <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/themes/css/bootstrap.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/themes/css/plugin.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(global_asset('assets/common/css/toastr.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/themes/css/odometer.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/themes/css/developer.css')); ?>">
    <?php endif; ?>

   <?php if(!empty(tenant()->id) && file_exists('assets/tenant/frontend/themes/css/dynamic-styles/'.tenant()->id.'-style.css') && !is_dir('assets/tenant/frontend/themes/css/dynamic-styles/'.tenant()->id.'-style.css')): ?>
        <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/themes/css/dynamic-styles/'.tenant()->id.'-style.css')); ?>">
    <?php endif; ?>


    <link rel="stylesheet" href="<?php echo e(global_asset('assets/landlord/common/css/helpers.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(global_asset('assets/common/css/jquery.ihavecookies.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(global_asset('assets/common/css/magnific-popup.css')); ?>">

    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.frontend.common-css','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('frontend.common-css'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
    <?php $__currentLoopData = $theme_header_css_files ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cssFile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <link rel="stylesheet" href="<?php echo e(loadCss($cssFile)); ?>" type="text/css">
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    <?php if(\App\Facades\GlobalLanguage::user_lang_dir() == 'rtl'): ?>
        <?php $__currentLoopData = $theme_header_rtl_css ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cssFile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <link rel="stylesheet" href="<?php echo e(loadCss($cssFile)); ?>" type="text/css">
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php echo $__env->make('tenant.frontend.partials.css-variable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.loaders.custom-loader','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('loaders.custom-loader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
    <?php echo $__env->yieldContent('style'); ?>

    <?php $__currentLoopData = $theme_header_js_files ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jsFile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <script src="<?php echo e(loadJs($jsFile)); ?>"></script>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</head>


<body class="<?php echo e(tenant()?->payment_log?->theme); ?>">

<?php echo $__env->make('tenant.frontend.partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php /**PATH /home/multipurposesass/public_html/core/resources/views/tenant/frontend/partials/header.blade.php ENDPATH**/ ?>