
<div class="headerCart-body ShowWishList ">
    <!-- Mobile device closed icon -->
    <span class="closed closedWishList "><i class="fa-solid fa-xmark"></i></span>
    <!-- Card Contents -->
    <div class="cartProduct-wrapper">
        <div class="small-tittle mb-40">
            <h2 class="tittle"><?php echo e(__('Wish List items')); ?></h2>
        </div>
        <?php
            $cart = \Gloudemans\Shoppingcart\Facades\Cart::instance("wishlist")->content();
            $subtotal = \Gloudemans\Shoppingcart\Facades\Cart::instance("wishlist")->subtotal();
        ?>

        <?php $__empty_1 = true; $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $product = \Modules\Product\Entities\Product::findOrFail($cart_item->id);
                $details_route = route('tenant.shop.product.details',$product->slug);
            ?>
            <figure class="singleCartproduct">
                <div class="proImg">
                    <a href="<?php echo e($details_route); ?>">
                        <?php echo render_image_markup_by_attachment_id($cart_item?->options?->image); ?>

                    </a>

                </div>
                <figcaption class="proDiscription">
                    <div class="cap">
                        <a href="<?php echo e($details_route); ?>" class="title"><?php echo e(Str::words($cart_item->name, 5)); ?> </a>
                        <span class="price"><?php echo e(amount_with_currency_symbol($cart_item->price)); ?></span>

                        <div class="cartCap">
                            <span class="name-subtitle d-block mt-2">
                                        <?php if($cart_item?->options?->color_name): ?>
                                    <?php echo e(__('Color:')); ?> <?php echo e($cart_item?->options?->color_name); ?>,
                                <?php endif; ?>

                                <?php if($cart_item?->options?->size_name): ?>
                                    <?php echo e(__('Size:')); ?> <?php echo e($cart_item?->options?->size_name); ?>

                                <?php endif; ?>

                                <?php if($cart_item?->options?->attributes): ?>
                                    <br>
                                    <?php $__currentLoopData = $cart_item?->options?->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($key.':'); ?> <?php echo e($attribute); ?><?php echo e(!$loop->last ? ',' : ''); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                     </span>
                        </div>
                    </div>

                    <div class="deleteProduct top_right_close_table_wishlist" data-product_hash_id="<?php echo e($cart_item->rowId); ?>">
                        <i class="fa-solid fa-xmark"></i>
                    </div>
                </figcaption>
            </figure>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <figure class="singleCartproduct">
                <p class="text-center"><?php echo e(__('No Item in Wishlist')); ?></p>
            </figure>
        <?php endif; ?>


        <?php if($cart->count() != 0): ?>
            <div class="totalPriceCart">
                <p class="subtotal"><?php echo e(__('subtotal')); ?></p> <span class="total"><?php echo e(site_currency_symbol().$subtotal); ?></span>
            </div>
        <?php endif; ?>

        <div class="btn-wrapper">
            <a href="<?php echo e(url('shop')); ?>" class="barberShop_cmn_btn btn_outline_1 color_one radius-5 w-100 mb-10"><?php echo e(__('Continue Shopping')); ?></a>
            <a href="<?php echo e(route('tenant.shop.wishlist.page')); ?>" class="barberShop_cmn_btn btn_bg_1 radius-5 w-100"><?php echo e(__('View Wishlist')); ?></a>
        </div>
    </div>
</div>
<?php /**PATH /home/multipurposesass/public_html/core/resources/views/tenant/frontend/partials/pages-portion/navbars/barber-shop-product-partial/wishlist.blade.php ENDPATH**/ ?>