
<div class="wishList">
    <div class="container">
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <table class="table-wishList custom--table table-border radius-10">
                    <thead>
                    <tr>
                        <th> <?php echo e(__('Product')); ?> </th>
                        <th> <?php echo e(__('Price')); ?> </th>
                        <th> <?php echo e(__('Quantity')); ?> </th>
                        <th> <?php echo e(__('Subtotal')); ?> </th>
                        <th> <?php echo e(__('Action')); ?> </th>
                    </tr>
                    </thead>
                    <tbody class="tableBody" id="cart_tbody">
                      <?php $__currentLoopData = $cart_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr data-product-id="<?php echo e($key); ?>" data-varinat-id="<?php echo e($data->variant_id); ?>">
                            <td class="productWrap d-flex align-items-center">
                                <?php echo render_image_markup_by_attachment_id($data?->options?->image); ?>

                                <div class="cartCap">
                                    <h5><?php echo e($data->name); ?></h5>
                                    <span class="name-subtitle d-block mt-2">
                                        <?php if($data?->options?->color_name): ?>
                                            <?php echo e(__('Color:')); ?> <?php echo e($data?->options?->color_name); ?>,
                                        <?php endif; ?>

                                        <?php if($data?->options?->size_name): ?>
                                            <?php echo e(__('Size:')); ?> <?php echo e($data?->options?->size_name); ?>

                                        <?php endif; ?>

                                        <?php if($data?->options?->attributes): ?>
                                            <br>
                                            <?php $__currentLoopData = $data?->options?->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($key.':'); ?> <?php echo e($attribute); ?><?php echo e(!$loop->last ? ',' : ''); ?>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                     </span>
                                </div>
                            </td>
                            <td><?php echo e(amount_with_currency_symbol($data->price)); ?></td>
                            <td class="ff-jost" data-label="Quantity">
                                <div class="countWrap">
                                    <div class="numberCount">

                                        <?php if(!$wishlist): ?>
                                           <div class="value-button minus substract">
                                               <i class="las la-minus"></i>
                                           </div>
                                        <?php endif; ?>
                                          <input type="number" class="qty_ quantity-input" <?php echo e($wishlist ? "disabled='true' readonly='true'" : ""); ?> value="<?php echo e($data->qty); ?>">
                                        <?php if(!$wishlist): ?>
                                           <div class="value-button plus">
                                               <i class="las la-plus"></i>
                                           </div>
                                        <?php endif; ?>

                                    </div>
                                </div>
                            </td>
                            <?php
                                $subtotal = $data->price * $data->qty;
                            ?>
                            <td class="price-td" data-label="Subtotal"><?php echo e(amount_with_currency_symbol($subtotal)); ?></td>

                            <td class="ff-jost <?php echo e($wishlist ? "d-flex justify-content-around align-items-center" : ""); ?>" data-label="Close" data-product_hash_id="<?php echo e($data->rowId); ?>">

                                <?php if($wishlist): ?>
                                    <div class="move-to-wishlist">
                                        <i class="las la-cart-arrow-down align-items-center"></i>
                                    </div>
                                <?php endif; ?>

                                <div class="close-table-<?php echo e($wishlist ? "wishlist" : "cart"); ?>">
                                    <i class="las la-trash-alt icon"></i>
                                </div>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <div class="col-lg-12">
                <div class="d-flex justify-content-between flex-wrap mt-40">
                    <div class="btn-wrapper mb-10">
                        <?php if(!$wishlist): ?>
                            <a href="javascript:void(0)" class="barberShop_cmn_btn btn_outline_1 radius-30 clear-cart-btn"> <?php echo e(__('Clear Cart')); ?> </a>
                        <?php endif; ?>
                        <a href="<?php echo e(url('shop')); ?>" class="barberShop_cmn_btn btn_bg_1 radius-30"><?php echo e(__('Continue Shopping')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>





<?php /**PATH /home/multipurposesass/public_html/core/Modules/Product/Resources/views/frontend/shop/cart/partials/cart_main_contents.blade.php ENDPATH**/ ?>