
<div id="tab-grid2" class="tab-content-item active">
    <div class="row">
        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $data = get_product_dynamic_price($product);
                $campaign_name = $data['campaign_name'];
                $regular_price = $data['regular_price'];
                $sale_price = $data['sale_price'];
                $discount = $data['discount'];
            ?>

            <div class="col-xl-4 col-lg-6 col-md-12 col-sm-6">
                <div class="singleProduct mb-24">
                    <div class="productImg imgEffect2">
                        <a href="<?php echo e(route('tenant.shop.product.details', $product->slug)); ?>">
                            <?php echo render_image_markup_by_attachment_id($product->image_id, '', 'grid'); ?>

                        </a>
                        <!-- sticker -->
                        <div class="sticky-wrap">
                            <?php if($discount != null): ?>
                                <span class="sticky stickyStye outStock"> <?php echo e($discount); ?>% <?php echo e(__('off')); ?> </span>
                            <?php endif; ?>

                            <?php if(!empty($product->badge)): ?>
                                <span class="sticky stickyStye"> <?php echo e($product?->badge?->name); ?> </span>
                            <?php endif; ?>
                        </div>

                        <?php echo $__env->make('product::frontend.shop.partials.product-options', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="productCap">
                        <h5 class="global-card-contents-title text-capitalize">
                            <a href="<?php echo e(route('tenant.shop.product.details', $product->slug)); ?>"> <?php echo e(Str::words($product->name, 4)); ?> </a>
                        </h5>

                        <?php echo render_product_star_rating_markup_with_count($product); ?>


                        <?php if($product->inventory?->stock_count > 0): ?>
                            <span class="quintity avilable"><?php echo e(__('In Stock')); ?> <span class="quintityNumber">(<?php echo e($product->inventory?->stock_count); ?>)</span> </span>
                        <?php else: ?>
                            <span class="quintity text-danger"><?php echo e(__('Stock Out')); ?> <span class="quintityNumber">(<?php echo e($product->inventory?->stock_count); ?>)</span> </span>
                        <?php endif; ?>

                        <div class="productPrice">
                            <strong class="regularPrice"><?php echo e($regular_price != null ? amount_with_currency_symbol( $sale_price) : ''); ?></strong>
                            <span class="offerPrice"><?php echo e(amount_with_currency_symbol($regular_price)); ?></span>

                        </div>

                        <div class="btn-wrapper mb-15">

                            <?php if(count($product->inventoryDetail) > 0 ): ?>
                                <a href="<?php echo e(route('tenant.shop.product.details',$product->slug)); ?>" class="cmn-btn-outline3 w-100"><?php echo e(__('View')); ?></a>
                            <?php else: ?>
                                <a href="#!" data-product_id="<?php echo e($product->id); ?>" class="cmn-btn-outline3 w-100 add-to-buy-now-btn"><?php echo e(__('Buy Now')); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


            <div class="pagination mt-60">
                <ul class="pagination-list">
                    <?php if(count($links) > 1): ?>
                        <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a data-page="<?php echo e($loop->iteration); ?>" href="<?php echo e($link); ?>" class="page-number <?php echo e($loop->iteration === $current_page ? "current" : ""); ?>"><?php echo e($loop->iteration); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </ul>
            </div>
    </div>
</div>
<?php /**PATH /home/multipurposesass/public_html/core/resources/views/themes/eCommerce/frontend/shop/partials/product-partials/grid-products.blade.php ENDPATH**/ ?>