<!DOCTYPE html>
<html dir="<?php echo e(\App\Facades\GlobalLanguage::user_lang_dir()); ?>" lang="<?php echo e(\App\Facades\GlobalLanguage::user_lang_slug()); ?>">
<head>

    <?php echo get_static_option('site_third_party_tracking_code_just_after_head'); ?>

    <?php echo get_static_option('site_google_analytics'); ?>


    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">


    <?php if(request()->is('home') || request()->is('/')): ?>
    <meta property="title" content="<?php echo e(get_static_option('site_'.get_user_lang().'_meta_title')); ?>" />
    <meta property="tags" content="<?php echo e(get_static_option('site_'.get_user_lang().'_meta_tags')); ?>" />
    <meta property="keywords" content="<?php echo e(get_static_option('site_'.get_user_lang().'_meta_keywords')); ?>" />
    <meta property="description" content="<?php echo e(get_static_option('site_'.get_user_lang().'_meta_description')); ?>" />

    <?php
        $og_meta_image = get_attachment_image_by_id(get_static_option('site_'.get_user_lang().'_og_meta_image'));
    ?>
    <meta property="og:title" content="<?php echo e(get_static_option('site_'.get_user_lang().'_og_meta_title')); ?>" />
    <meta property="og:description" content="<?php echo e(get_static_option('site_'.get_user_lang().'_og_meta_description')); ?>" />
    <meta property="og:image" content="<?php echo e($og_meta_image['img_url'] ?? ''); ?>" />
    <?php endif; ?>

    <?php if(Route::currentRouteName() === 'landlord.dynamic.page'): ?>
        <?php echo render_page_meta_data($page_post); ?>

    <?php else: ?>
        <?php echo $__env->yieldContent('meta-data'); ?>
    <?php endif; ?>

    <?php echo SEOMeta::generate(); ?>

    <?php echo JsonLd::generate(); ?>


    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>


    <?php echo render_favicon_by_id(get_static_option('site_favicon')); ?>


    <?php
        $static_page_meta_data = get_static_option('site_'.get_user_lang().'_meta_title');
    ?>

    <title>
        <?php if(!request()->routeIs('landlord.homepage')): ?>
            <?php if(Route::currentRouteName() === 'landlord.dynamic.page'): ?>
                <?php
                    $dynamic_page_title = $page_post->getTranslation('title',get_user_lang());
                    $static_page_meta_data = $page_post->metainfo?->getTranslation('title',get_user_lang());
                    $condition_other_dynamic_pages = !empty($static_page_meta_data) ? $static_page_meta_data : $dynamic_page_title;
                ?>
                <?php echo e($condition_other_dynamic_pages); ?>

            <?php else: ?>
                <?php echo $__env->yieldContent('title'); ?>
            <?php endif; ?>
            -
            <?php echo e(get_static_option('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_title')); ?>

        <?php else: ?>

            <?php
                $site_meta_tittle = !empty($page_post) ? $page_post->metainfo?->getTranslation('title',get_user_lang()) : '';
                $site_page_tittle = !empty($page_post) ? $page_post->getTranslation('title',get_user_lang()) : '';
                $condition_meta_title = !empty($site_meta_tittle) ? $site_meta_tittle : $site_page_tittle;
            ?>

              <?php echo e($condition_meta_title ?? get_static_option('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_title')); ?>


            <?php if(!empty(get_static_option('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_tag_line'))): ?>
                - <?php echo e(get_static_option('site_'.\App\Facades\GlobalLanguage::user_lang_slug().'_tag_line')); ?>

            <?php endif; ?>
        <?php endif; ?>
    </title>

    <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/frontend/css/bootstrap.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/frontend/css/plugin.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(global_asset('assets/tenant/frontend/css/custom-dashboard.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/frontend/css/main-style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/common/css/helpers.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(global_asset('assets/common/css/jquery.ihavecookies.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/frontend/css/developer.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/frontend/css/dynamic-style.css')); ?>">

    <?php if(\App\Facades\GlobalLanguage::user_lang_dir() == 'rtl'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/frontend/css/rtl.css')); ?>">
    <?php endif; ?>

    <?php echo $__env->make('landlord.frontend.partials.font-manage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('landlord.frontend.partials.color-font-variable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('style'); ?>

    <?php echo $__env->yieldContent('seo_data'); ?>
    <?php echo get_static_option('site_third_party_tracking_code'); ?>

</head>
<body>
<?php echo get_static_option('site_third_party_tracking_code_just_after_body'); ?>

<?php echo $__env->make('landlord.frontend.partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php /**PATH /home/multipurposesass/public_html/core/resources/views/landlord/frontend/partials/header.blade.php ENDPATH**/ ?>