
<?php if(get_static_option('landlord_frontend_topbar_show_hide')): ?>

    <?php
        $theme = get_static_option('tenant_default_theme');
        $condition_for_portfolio_inner = $theme == 'portfolio' && !request()->is('/') ? 'portfolio_inner_topbar' : '';
    ?>

    <div class="header-top agency_topbar <?php echo e($theme); ?> <?php echo e($condition_for_portfolio_inner); ?>">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="d-flex justify-content-between flex-wrap align-items-center">
                        <div class="header-info-left">
                            <?php if(!empty(get_static_option('landlord_frontend_contact_info_show_hide'))): ?>
                                <ul class="listing">
                                    <li class="listItem"><i class="fa-solid fa-phone icon"></i><?php echo e(get_static_option('topbar_phone')); ?></li>
                                    <li class="listItem"><i class="fa-solid fa-envelope icon"></i> <?php echo e(get_static_option('topbar_email')); ?></li>
                                </ul>
                            <?php endif; ?>
                        </div>
                        <div class="header-info-right">

                            <ul class="user-account">
                                <?php if(auth()->check()): ?>
                                    <?php
                                        $route = auth()->guest() == 'admin' ? route('tenant.admin.dashboard') : route('tenant.user.home');
                                    ?>
                                    <li class="listItem"><a href="<?php echo e($route); ?>"><?php echo e(__('Dashboard')); ?></a> <span>/</span>
                                        <a href="<?php echo e(route('tenant.user.logout')); ?>"><?php echo e(__('Logout')); ?></a>
                                    </li>
                                <?php else: ?>

                                    <li class="listItem">
                                        <?php if(!empty(get_static_option('tenant_login_show_hide'))): ?>
                                            <a href="<?php echo e(route('tenant.user.login')); ?>"><?php echo e(__('Login')); ?></a>
                                            <span>/</span>
                                        <?php endif; ?>
                                        <?php if(!empty(get_static_option('tenant_register_show_hide'))): ?>
                                            <a href="<?php echo e(route('tenant.user.register')); ?>"><?php echo e(__('Register')); ?></a>
                                        <?php endif; ?>
                                    </li>
                                <?php endif; ?>
                            </ul>
                            <div class="language_dropdown <?php if(get_user_lang_direction() == 'rtl'): ?> ml-1 <?php else: ?> mr-1 <?php endif; ?> d-none" id="languages_selector">
                                <?php if(auth()->check()): ?>
                                    <?php
                                        $route = auth()->guest() == 'admin' ? route('tenant.admin.dashboard') : route('tenant.user.home');
                                    ?>
                                    <div class="selected-language"><?php echo e(__('Account')); ?><i class="fas fa-caret-down"></i></div>
                                    <ul>
                                        <li class="listItem"><a href="<?php echo e($route); ?>"><?php echo e(__('Dashboard')); ?></a>
                                        <li class="listItem"><a href="<?php echo e(route('tenant.user.logout')); ?>"><?php echo e(__('Logout')); ?></a></li>
                                    </ul>
                                <?php else: ?>
                                    <div class="selected-language"><?php echo e(__('Login')); ?><i class="fas fa-caret-down"></i></div>
                                    <ul>
                                        <li class="listItem"><a class="listItem" href="<?php echo e(route('tenant.user.login')); ?>"><?php echo e(__('Login')); ?></a>
                                        <li class="listItem"><a class="listItem" href="<?php echo e(route('tenant.user.register')); ?>"><?php echo e(__('Register')); ?></a>
                                    </ul>
                                <?php endif; ?>
                            </div>
                            <?php if(get_static_option('landlord_frontend_language_show_hide')): ?>
                                <!-- Select  -->
                                <div class="select-language">
                                    <select class="niceSelect tenant_languages_selector">
                                        <?php $__currentLoopData = \App\Facades\GlobalLanguage::all_languages(\App\Enums\StatusEnums::PUBLISH); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $exploded = explode('(',$lang->name);
                                            ?>
                                            <option class="lang_item" value="<?php echo e($lang->slug); ?>" ><?php echo e(current($exploded)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            <?php endif; ?>

                            <?php if(!empty(get_static_option('landlord_frontend_social_info_show_hide'))): ?>
                                <ul class="header-cart">
                                    <li class="listItem"><a href="<?php echo e(get_static_option('topbar_facebook_url')); ?>" class="social"><i class="lab la-facebook-f icon"></i></a></li>
                                    <li class="listItem"> <a href="<?php echo e(get_static_option('topbar_instagram_url')); ?>" class="social"><i class="lab la-instagram icon"></i></a></li>
                                    <li class="listItem"> <a href="<?php echo e(get_static_option('topbar_linkedin_url')); ?>" class="social"><i class="lab la-linkedin-in icon"></i></a></li>
                                    <li class="listItem"> <a href="<?php echo e(get_static_option('topbar_twitter_url')); ?>" class="social"><i class="lab la-twitter icon"></i></a></li>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>




<header class="header-style-01">
    <nav class="navbar agency_nav navbar-area navbar-padding navbar-expand-lg">
        <div class="container nav-container">
            <div class="responsive-mobile-menu">
                <div class="logo-wrapper">
                    <a href="<?php echo e(url('/')); ?>" class="logo">
                        <?php echo render_image_markup_by_attachment_id(get_static_option('site_logo'),'logo'); ?>

                    </a>
                </div>
                <a href="javascript:void(0)" class="click-nav-right-icon">
                    <i class="las la-ellipsis-v"></i>
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#book_point_menu">
                    <span class="navbar-toggler-icon"></span>
                </button>
            </div>
            <div class="collapse navbar-collapse" id="book_point_menu">
                <ul class="navbar-nav">
                    <?php echo render_frontend_menu($primary_menu); ?>

                </ul>
            </div>
            <div class="navbar-right-content show-nav-content">
                <div class="single-right-content">
                    <div class="navbar-right-btn">
                        <a href="<?php echo e(get_static_option('agency_top_contact_button_'.get_user_lang().'_url')); ?>" class="cmn-agency-btn cmn-agency-btn-bg-1 cmn-agency-btn-small radius-0 ">
                            <?php echo e(get_static_option('agency_top_contact_button_'.get_user_lang().'_text') ?? __('Contact')); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </nav>
</header>

<?php /**PATH /home/multipurposesass/public_html/core/resources/views/themes/agency/headerNavbarArea/navbar.blade.php ENDPATH**/ ?>