<?php $__env->startSection('title'); ?>
    <?php echo e(__('Dashboard')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
    <style>
        .tenant_recent_orders .card .card-body {
            overflow: hidden;
        }

    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="col-12 grid-margin stretch-card tenant_recent_orders">
        <div class="card">

            <?php if(!empty($current_package)): ?>
                <div class="main">
                    <div class="alert border-left border-primary text-white text-center bg-gradient-info">
                        <strong><?php echo e(__('Current Package :')); ?> </strong> <?php echo e($current_package->package_name); ?>

                        <span class="badge badge-warning text-dark">
                        <?php echo e(\App\Enums\PricePlanTypEnums::getText(optional($current_package->package)->type )); ?>

                    </span>

                        <?php if(optional(tenant()->payment_log)->status == 'trial'): ?>
                            <?php
                                $days = get_trial_days_left(tenant());
                            ?>

                            <strong class="text-capitalize"> ( <?php echo e(optional(tenant()->user?->payment_single_log)->status); ?> : <?php echo e($days ?? ''); ?> <?php echo e(__('Days Left')); ?>)</strong>
                        <?php else: ?>
                            <strong> ( <?php echo e(__('Expire Date :')); ?> <?php echo e($current_package->expire_date ?? ''); ?>)</strong>
                        <?php endif; ?>

                        <a class="btn btn-dark btn-sm pull-right" href="<?php echo e(route('landlord.homepage') .'#price_plan_section'); ?>" target="_blank"><?php echo e(__('Buy a Plan')); ?></a>
                    </div>

                </div>
            <?php endif; ?>



            <?php if(tenant()->instruction_status == 1): ?>
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title text-center"><?php echo e(__('Set up your website in few easy steps')); ?></h4>
                </div>
                <div class="card-body">
                    <div class="row">

                        <?php
                            $all_website_instructions = \App\Models\WebsiteInstruction::where('status',1)->get();
                        ?>

                        <?php $__currentLoopData = $all_website_instructions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instruction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <div class="col-md-4">
                                <div class="card mb-3">

                                    <?php
                                        $img = get_lnadlord_attachment_image_by_id_without_query($instruction->imageDetails,$instruction->image);
                                    ?>

                                    <div class="card-body">
                                        <img class="card-img-top" src="<?php echo e($img['img_url'] ?? ''); ?>" alt="Website Logo" style="max-width: 200px;">
                                        <h5 class="card-title mt-3"><?php echo e($instruction->getTranslation('title',default_lang())); ?></h5>
                                        <p class="card-text"><?php echo e($instruction->getTranslation('description',default_lang())); ?></p>

                                        <?php
                                            $all_repeater_data =  !empty($instruction->repeater_data) ? unserialize($instruction->repeater_data,['class' => false]) : ['title' => ['']];
                                        ?>


                                        <?php $__currentLoopData = $all_repeater_data['button_text'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $button_text): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(replace_instruction_url($all_repeater_data['button_url'][$key] ?? '')); ?>" class="btn btn-primary mt-3 mr-3"><?php echo e(__($button_text) ?? ''); ?></a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <div class="card-body ">
                <div class="row">
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-danger card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Page')); ?><i class="las la-user-shield mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_page); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-danger card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Admins')); ?><i class="las la-user-shield mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_admin); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-info card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Users')); ?><i class="las la-user-shield mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_user); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-success card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Blogs')); ?><i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($all_blogs); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-info card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Services')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_services); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-primary card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Language')); ?><i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_language); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-warning card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Brand')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_brand); ?></h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-success card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Products')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_product); ?></h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-info card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Campaign')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_campaign); ?></h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-danger card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Event')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_event); ?></h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-primary card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Job')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_job); ?></h2>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 stretch-card grid-margin">
                        <div class="card bg-gradient-warning card-img-holder text-white">
                            <div class="card-body">
                                <img src="<?php echo e(global_asset('assets/landlord/admin/images/circle.png')); ?>" class="card-img-absolute" alt="circle-image">
                                <h4 class="font-weight-normal mb-3"><?php echo e(__('Total Article')); ?> <i class="mdi mdi-diamond mdi-24px float-right"></i>
                                </h4>
                                <h2 class="mb-5"><?php echo e($total_article); ?></h2>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="row">
                    <div class="col-lg-6 grid-margin landlord_recent_table">
                        <h3 class=" text-center mb-4"><?php echo e(__('Recent Product Order Logs')); ?></h3>

                        <table class="table table-responsive table-bordered">
                            <thead class="text-white bg-purple">
                            <tr>
                                <th> <?php echo e(__('ID')); ?> </th>
                                <th> <?php echo e(__('Order ID')); ?></th>
                                <th> <?php echo e(__('User Name ')); ?></th>
                                <th> <?php echo e(__('Order Amount')); ?> </th>
                                <th> <?php echo e(__('Payment Status')); ?> </th>
                                <th> <?php echo e(__('Created At')); ?> </th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $recent_product_order_logs ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key + 1); ?></td>
                                    <td><?php echo e($data->id ?? ''); ?></td>
                                    <td> <?php echo e($data->name); ?> </td>
                                    <td><?php echo e(amount_with_currency_symbol($data->total_amount)); ?></td>
                                    <td> <?php echo e($data->payment_status); ?> </td>
                                    <td><?php echo e($data->created_at->diffForHumans()); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="col-lg-6 grid-margin landlord_recent_table" >
                        <h3 class=" text-center mb-4"><?php echo e(__('Recent Donation Logs')); ?></h3>

                        <table class="table table-responsive table-bordered">
                            <thead class="text-white bg-purple">
                            <tr>
                                <th> <?php echo e(__('ID')); ?> </th>
                                <th> <?php echo e(__('Order ID')); ?></th>
                                <th> <?php echo e(__('User Name ')); ?></th>
                                <th> <?php echo e(__('Amount')); ?> </th>
                                <th> <?php echo e(__('Payment Status')); ?></th>
                                <th> <?php echo e(__('Created At')); ?> </th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $recent_donation_logs ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key + 1); ?></td>
                                    <td><?php echo e($data->id ?? ''); ?></td>
                                    <td> <?php echo e($data->name); ?> </td>
                                    <td><?php echo e(amount_with_currency_symbol($data->amount)); ?></td>
                                    <td> <?php echo e($data->status  == 1 ? __('Complete') : __('Pending')); ?> </td>
                                    <td><?php echo e($data->created_at->diffForHumans()); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="col-lg-6 grid-margin landlord_recent_table">
                        <h3 class=" text-center mb-4"><?php echo e(__('Recent Event Logs')); ?></h3>

                        <table class="table table-responsive table-bordered">
                            <thead class="text-white bg-purple">
                            <tr>
                                <th> <?php echo e(__('ID')); ?> </th>
                                <th> <?php echo e(__('Order ID')); ?></th>
                                <th> <?php echo e(__('User Name ')); ?></th>
                                <th> <?php echo e(__('Amount')); ?> </th>
                                <th> <?php echo e(__('Payment Status')); ?></th>
                                <th> <?php echo e(__('Created At')); ?> </th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $recent_event_logs ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key + 1); ?></td>
                                    <td><?php echo e($data->id ?? ''); ?></td>
                                    <td> <?php echo e($data->name); ?> </td>
                                    <td><?php echo e(amount_with_currency_symbol($data->amount)); ?></td>
                                    <td> <?php echo e($data->status == 1 ? __('Complete') : __('Pending')); ?> </td>
                                    <td><?php echo e($data->created_at->diffForHumans()); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="col-lg-6 grid-margin landlord_recent_table">
                        <h3 class=" text-center mb-4"><?php echo e(__('Recent Job Post Logs')); ?></h3>

                        <table class="table table-responsive table-bordered">
                            <thead class="text-white bg-purple">
                            <tr>
                                <th> <?php echo e(__('ID')); ?> </th>
                                <th> <?php echo e(__('Order ID')); ?></th>
                                <th> <?php echo e(__('User Name ')); ?></th>
                                <th> <?php echo e(__('Price')); ?> </th>
                                <th> <?php echo e(__('Payment Status')); ?></th>
                                <th> <?php echo e(__('Created At')); ?> </th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $recent_job_logs ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key + 1); ?></td>
                                    <td><?php echo e($data->id ?? ''); ?></td>
                                    <td> <?php echo e($data->name); ?> </td>
                                    <td><?php echo e(amount_with_currency_symbol($data->amount)); ?></td>
                                    <td> <?php echo e($data->status == 1 ? __('Complete') : __('Pending')); ?> </td>
                                    <td><?php echo e($data->created_at->diffForHumans()); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('tenant.admin.admin-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/multipurposesass/public_html/core/resources/views/tenant/admin/admin-home.blade.php ENDPATH**/ ?>