<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('User Home')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <?php echo e(__('User Home')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
    <style>
        .badge{
            font-size: 15px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('section'); ?>
    <?php
        $auth_user = Auth::guard('web')->user();
    ?>
    <div class="row g-4">
        <div class="col-md-12">
            <?php if($auth_user->domains->isNotEmpty()): ?>
                <div class="btn-wrapper mb-3 mt-2 d-flex justify-content-between" >
                    <a href="<?php echo e(tenant_url_with_protocol($auth_user->subdomain) .'.'. getenv('CENTRAL_DOMAIN') ?? ''); ?>"
                       class="btn btn-info mx-2" target="_blank"><?php echo e(__('Go to your site')); ?></a>
                    <a href="<?php echo e(tenant_url_with_protocol($auth_user->subdomain).'.'. getenv('CENTRAL_DOMAIN') .'/admin' ?? ''); ?>"
                       class="btn btn-primary" target="_blank"><?php echo e(__('Go to your admin panel')); ?></a>
                </div>
            <?php else: ?>
                <div class="btn-wrapper mb-3 mt-2 float-right" >
                    <?php
                        $price_page = get_page_slug(get_static_option('pricing_plan'));
                    ?>
                    <a href="<?php echo e(url($price_page)); ?>" class="btn btn-success mx-2"><?php echo e(__('Create a website')); ?></a>
                </div>
            <?php endif; ?>
        </div>

        <div class="col-xl-6 col-md-6 orders-child">
            <div class="single-orders">

                <div class="orders-flex-content">
                    <div class="icon">
                        <i class="las la-tasks"></i>
                    </div>
                    <div class="contents">
                        <h2 class="order-titles"> <?php echo e($package_orders ?? ''); ?> </h2>
                        <span class="order-para"><?php echo e(__('Total Orders')); ?> </span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6 col-md-6 orders-child">
            <div class="single-orders">

                <div class="orders-flex-content">
                    <div class="icon">
                        <i class="las la-tasks"></i>
                    </div>
                    <div class="contents">
                        <h2 class="order-titles"> <?php echo e($support_tickets ?? ''); ?> </h2>
                        <span class="order-para"><?php echo e(__('Support Tickets')); ?> </span>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12 mt-5">
            <div class="subdomains mb-5">
                <h4 class="mb-3 text-uppercase text-center"><?php echo e(__('Your Subdomains')); ?></h4>
                <div class="payment">
                    <table class="table table-responsive table-bordered recent_payment_table">
                        <thead>
                        <th><?php echo e(__('ID')); ?></th>
                        <th><?php echo e(__('Site')); ?></th>
                        <th><?php echo e(__('Admin Panel')); ?></th>
                        </thead>
                        <tbody class="w-100">
                        <?php
                            $user = Auth::guard('web')->user();
                        ?>

                        <?php $__currentLoopData = $user->tenant_details ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($key +1); ?></td>
                                <td>
                                    <a class="badge rounded-pill bg-primary px-4" href="<?php echo e(tenant_url_with_protocol(optional($data->domain)->domain)); ?>"><?php echo e(__('Go to your Website')); ?>

                                        <br> <small class="mt-4">(<?php echo e($data->domain?->domain); ?>)</small>
                                    </a>
                                </td>
                                <td>
                                    <a class="badge rounded-pill bg-danger px-4" href="<?php echo e(tenant_url_with_protocol(optional($data->domain)->domain).'/admin'); ?>">
                                        <?php echo e(__('Go to your website admin panel')); ?>

                                        <br> <small class="mt-4">(<?php echo e($data->domain?->domain); ?>)</small>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <h4 class="mb-3 text-uppercase text-center"><?php echo e(__('Recent Orders')); ?></h4>
            <div class="payment">
                <table class="table table-responsive table-bordered recent_payment_table">
                    <thead>
                    <th><?php echo e(__('ID')); ?></th>
                    <th><?php echo e(__('Package Name')); ?></th>
                    <th><?php echo e(__('Amount')); ?></th>
                    <th><?php echo e(__('Start Date')); ?></th>
                    <th><?php echo e(__('Expire Date')); ?></th>
                    <th><?php echo e(__('Order Status')); ?></th>
                   <th><?php echo e(__('Renew Taken')); ?></th>


                    </thead>
                    <tbody class="w-100">
                    <?php $__currentLoopData = $recent_logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key +1); ?></td>
                            <td><?php echo e($data->package_name); ?></td>
                            <td><?php echo e(amount_with_currency_symbol($data->package_price)); ?></td>
                            <td><?php echo e(date('d-m-Y', strtotime($data->start_date))); ?></td>

                            <td>
                                <?php if(!empty($data->expire_date)): ?>
                                    <?php echo e(date('d-m-Y', strtotime($data->expire_date))); ?>

                                <?php endif; ?>
                                <?php if(!empty($data->trial_expire_date) && $data->status == 'trial'): ?>
                                    <?php echo e(date('d-m-Y', strtotime($data->trial_expire_date))); ?>

                                <?php endif; ?>
                            </td>

                            <td><?php echo e($data->status); ?></td>
                            <td><?php echo e($data->renew_status); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>






<?php echo $__env->make('landlord.frontend.user.dashboard.user-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/xgenious/Desktop/xgenious/localhost/multisaas-update/core/resources/views/landlord/frontend/user/dashboard/user-home.blade.php ENDPATH**/ ?>