<?php $__env->startSection('title'); ?>
    <?php echo e(__('Payment Success For:')); ?> <?php echo e(optional($event_logs->event)->getTranslation('title',get_user_lang())); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Payment Success For:')); ?> <?php echo e(optional($event_logs->event)->getTranslation('title',get_user_lang())); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('style'); ?>
    <style>
        /* ticket style */
        .ticket{
            max-width: 800px;
            background: #fafafa;
            padding: 80px 60px 50px 60px;
            margin: 0 auto;
        }
        .ticket .title{
            color: #000;
            font-size: 20px;
            display: block;
            font-weight: 500;
            margin-bottom:25px;
        }
        .ticket .mainTitle{
            color: #000;
            font-size: 48px;
            display: block;
            font-weight: 600;
            margin-bottom:50px;
        }
        .ticketDiscription .pera{
            color: #000;
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 6px;
            display: block;
        }
        .ticketDiscription .barcode{
            max-width:90px;
            border-radius: 8px;
        }
        .peraMargin{
            margin-bottom: 35px !important;
        }
        .ticket table {
            width: 100%;
            display: block;
        }
        .ticket tbody {
            width: 100%;
            display: block;
        }
        .ticket tbody tr {
            display: flex;
            justify-content: space-between;
            width: 100%;
        }
        .ticket tbody tr td {
            width: 42%;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="confirmationArea section-padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-10">
                    <div class="confirmationWrapper text-center">
                        <div class="row">
                            <div class="col-md-12">
                                <!-- Check Mark icon -->
                                <div class="success-checkmark">
                                    <div class="check-icon">
                                        <span class="icon-line line-tip"></span>
                                        <span class="icon-line line-long"></span>
                                        <div class="icon-circle"></div>
                                        <div class="icon-fix"></div>
                                    </div>
                                </div>
                                <div class="confirmInfo mb-50 mt-40">
                                    <h2 class="confirm"><?php echo e(__('Your Booking is Confirm')); ?></h2>
                                    <h6 class="info"><?php echo e(__('Your Ticket Number')); ?></h6>
                                    <p class="pera"><?php echo e($event_logs->id); ?></p>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-6">
                                <div class="confirmInfo mb-40">
                                    <h6 class="info"><?php echo e(__('Event Date')); ?></h6>
                                    <p class="pera"><?php echo e(__('Date')); ?>: <?php echo e($event->date); ?></p>
                                </div>
                            </div>
                            <div class="col-md-4 col-sm-6">
                                <div class="confirmInfo mb-40">
                                    <h6 class="info"><?php echo e(__('Event Time')); ?></h6>
                                    <p class="pera"><?php echo e($event->time); ?></p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="confirmInfo mb-40">
                                    <h6 class="info"><?php echo e(__('Event Venue')); ?></h6>
                                    <p class="pera"><?php echo e($event->venue_location); ?></p>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="btn-wrapper pt-40">
                                    <a class="cmn-btn1 hero-btn w-100" href="<?php echo e(route('tenant.frontend.event.ticket.download',$event_logs->id)); ?>"><?php echo e(__('Download your Ticket')); ?></a>
                                    <?php if(auth()->guard('web')->check()): ?>
                                        <a  href="<?php echo e(route('tenant.user.home')); ?>" class="btn btn-dark hero-btn w-100 mt-3"><?php echo e(__('Go to dashboard')); ?></a>
                                    <?php else: ?>
                                        <a  href="<?php echo e(url('/')); ?>" class="btn btn-dark hero-btn w-100 mt-3"><?php echo e(__('Go to home')); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="col-xl-6">
                    <div class="ticket">
                        <table>
                            <tr>
                                <h6 class="title"><?php echo e(__('Event Name')); ?></h6>
                                <a href="<?php echo e(route('tenant.frontend.event.payment',$event->slug)); ?>">
                                    <h1 class="mainTitle"><?php echo e($event->getTranslation('title',get_user_lang())); ?></h1>
                                </a>
                            </tr>

                            <tr>
                                <td>
                                    <div class="ticketDiscription">
                                        <span class="pera"><?php echo e(__('Date and Time')); ?></span>
                                        <span class="pera"><?php echo e($event->date); ?></span>
                                        <span class="pera peraMargin"><?php echo e($event->time); ?></span>
                                        <span class="pera"><?php echo e(__('Price')); ?></span>
                                        <span class="pera peraMargin"><?php echo e(amount_with_currency_symbol($event_logs->amount)); ?></span>
                                        <span class="pera"><?php echo e(__('Venue')); ?> : <?php echo e($event->venue_location); ?></span>
                                    </div>
                                </td>
                                <td>
                                    <div class="ticketDiscription ticketDiscription2">
                                        <span class="pera"><?php echo e(__('Name')); ?></span>
                                        <span class="pera peraMargin"><?php echo e($event_logs->name); ?></span>
                                        <span class="pera"><?php echo e(__('Number of ticket')); ?></span>
                                        <span class="pera peraMargin"><?php echo e($event_logs->ticket_qty); ?></span>
                                        <?php echo QrCode::size(120)->generate($qr_code_markup); ?>

                                    </div>
                                     <small class="text-primary"><?php echo e(__('Scan qr code to see')); ?></small>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('tenant.frontend.frontend-page-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/multipurposesass/public_html/core/Modules/Event/Resources/views/tenant/frontend/event/payment/success.blade.php ENDPATH**/ ?>