
<!doctype html>
<html dir="<?php echo e(\App\Facades\GlobalLanguage::user_lang_dir()); ?>" lang="<?php echo e(\App\Facades\GlobalLanguage::user_lang_slug()); ?>">
<head>
    <meta charset="UTF-8">
    <title><?php echo e(__('Event Attendance Invoice')); ?></title>
    <style type="text/css">
        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table {
            font-size: x-small;
        }
        td  {
            font-size: 14px;
            padding: 5px;
            vertical-align: middle !important;
        }
        table tr th {
            line-height: 20px;
            font-size: 14px;
            font-weight: 700;
            padding: 5px 5px;
        }
        tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }
        .gray {
            background-color: lightgray
        }
        .table-footer tr td {
            text-align: left;
            font-size: 14px;
            padding: 5px;
        }
        .table-top td p,
        .table-footer td p {
            line-height: 18px;
            display: block;
            padding: 5px 0;
        }
        .totalAmount {
            font-width: 700;
            font-size: 25px;
            text-align: right;
            display: block;
        }
        table thead tr th {
            border: 0;
        }
        table thead tr th {
            border: 0;
        }
        table thead tr th:first-child {
            text-align: left;
            padding: 10px 30px;
        }
        table thead tr th:last-child {
            text-align: right;
            padding: 10px 30px;
        }
        .borderStyle{
            margin-bottom: 5px;
        }
        .border-top{ border-top: 2px solid #000;}

        .singleItems{
            font-size: 14px;
        }

    </style>
</head>
<body>


<table width="100%" class="table-top">
    <tr>
        <td valign="top">
            <?php
                $logo = get_attachment_image_by_id(get_static_option('site_logo'));
            ?>
            <img src="<?php echo e($logo['img_url']); ?>" alt="" width="150"/>
        </td>
    </tr>

    <tr>
        <td valign="top">
            <p><strong><?php echo e(__('Date')); ?></strong>: <?php echo e(date('d-m-Y',strtotime($event_details->created_at))); ?></p>
            <p><strong><?php echo e(__('From')); ?></strong>: <?php echo e(get_static_option('tenant_site_global_email')); ?></p>
            <p><strong><?php echo e(__('To')); ?></strong>: <?php echo e($event_details->name); ?></p>
            <p><strong><?php echo e(__('User Email')); ?></strong>: <?php echo e($event_details->email); ?></p>
        </td>

        <td align="right">
            <h3><?php echo e(get_static_option('company_name')); ?></h3>
            <p><?php echo e(get_static_option('company_address')); ?></p>
            <p><?php echo e(get_static_option('company_email')); ?></p>
            <p><?php echo e(get_static_option('company_phone')); ?></p>
        </td>
    </tr>
</table>

<table class="table-footer" width="100%">
    <thead style="background-color: #353935; color: white">
    <tr>
        <th><?php echo e(__('Description')); ?></th>
        <th><?php echo e(__('Amount')); ?></th>
    </tr>
    </thead>
    <tbody>
    <tr>
        <td valign="top">
            <div>
                <p class="singleItems"><strong><?php echo e(__('Event Title')); ?></strong>: <?php echo e(optional($event_details->event)->getTranslation('title',get_user_lang())); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Event Location')); ?></strong>: <?php echo e($event_details->event?->venue_location); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Start Date')); ?></strong>: <?php echo e($event_details->event?->date); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Start Time')); ?></strong>: <?php echo e($event_details->event?->time); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Ticket Quantity')); ?></strong>: <?php echo e($event_details->ticket_qty); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Amount')); ?></strong>: <?php echo e($event_details->amount); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Payment Gateway')); ?></strong>: <?php echo e(str_replace('_',' ',$event_details->payment_gateway)); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Payment Status')); ?></strong>: <?php echo e(\App\Enums\DonationPaymentStatusEnum::getText($event_details->status)); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Transaction ID')); ?></strong>: <?php echo e($event_details->transaction_id); ?></p>
            </div>
        </td>

        <td align="right">
            <div class="borderStyle">
                <h6 class="singleItems" ><strong><?php echo e(__('Event Cost')); ?></strong>: <?php echo e(amount_with_currency_symbol($event_details->amount)); ?></h6>
                <h2 class=" border-top" ><strong><?php echo e(__('Total Amount')); ?>: </strong> <?php echo e(amount_with_currency_symbol($event_details->amount)); ?></h2>
            </div>
        </td>
    </tr>
    </tbody>

</table>





<?php /**PATH /home/multipurposesass/public_html/core/resources/views/tenant/frontend/invoice/event.blade.php ENDPATH**/ ?>