<section class="softwareFirm_blog_area padding-top-100 padding-bottom-50" data-padding-top="<?php echo e($data['padding_top']); ?>" data-padding-bottom="<?php echo e($data['padding_bottom']); ?>">
    <div class="container">
        <div class="softwareFirm_sectionTitle">
            <h2 class="title"><?php echo e($data['title']); ?></h2>
        </div>
        <div class="row g-4 mt-4">
            <?php $__currentLoopData = $data['blogs'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $url = route('tenant.frontend.blog.single',$item->slug);
                    $category = $item->category?->title;
                    $category_route = route('tenant.frontend.blog.category',['id'=> $item->category_id, 'any' => \Illuminate\Support\Str::slug($category)]);
                ?>
            <div class="col-lg-4 col-md-6">
                <div class="softwareFirm_blog softwareFirm_section_bg_2">
                    <div class="softwareFirm_blog__thumb">
                        <a href="<?php echo e($url); ?>">
                            <?php echo render_image_markup_by_attachment_id($item->image); ?>

                        </a>
                    </div>
                    <div class="softwareFirm_blog__contents">
                        <div class="softwareFirm_blog__tag">
                            <a href="<?php echo e($url); ?>" class="softwareFirm_blog__tag__item"><i class="fa-solid fa-calendar-days"></i><?php echo e(date('d M Y',strtotime($item->created_at))); ?></a>
                            <a href="<?php echo e($category_route); ?>" class="softwareFirm_blog__tag__item"><i class="las la-tag"></i><?php echo e($category); ?></a>
                        </div>
                        <h3 class="softwareFirm_blog__contents__title mt-3"> <a href="<?php echo e($url); ?>"><?php echo e($item->title); ?></a> </h3>
                        <p class="softwareFirm_blog__contents__para mt-3">
                            <?php echo $item->excerpt ?? strip_tags(\Illuminate\Support\Str::words($item->blog_content,35)); ?>

                        </p>
                        <div class="btn-wrapper mt-3">
                            <a href="<?php echo e($url); ?>" class="softwareFirm_blog__btn"> <?php echo e($data['more_text']); ?> <i class="fa-solid fa-arrow-right"></i> </a>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH /home/multipurposesass/public_html/core/plugins/PageBuilder/views/tenant/software-business/blog-area.blade.php ENDPATH**/ ?>