<?php $__env->startSection('title'); ?>
   <?php echo e(__('Donation Payment ')); ?> : <?php echo e($donation->getTranslation('title',get_user_lang())); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Donation Payment ')); ?> : <?php echo e($donation->getTranslation('title',get_user_lang())); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="packageArea section-padding">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 col-lg-7 col-md-6 packageWrapper mb-40">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="btn-wrapper mb-20">
                                <a href="<?php echo e(route('tenant.dynamic.page','donation') ?? url('/')); ?>" class="cmn-btn-outline3"> <?php echo e(__('Go Back')); ?> </a>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="col-lg-12">
                                <?php
                                    $custom_amounts = get_static_option('donation_custom_amount');
                                    $explode_custom_amounts = explode(',',$custom_amounts);
                                    $default_amount = amount_with_currency_symbol(get_static_option('donation_default_amount'));
                                    $default_amount_without_currency = get_static_option('donation_default_amount');
                                    $auth_user = auth()->guard('web');
                                ?>
                                <ul class="selectPricing mb-20">
                                    <?php $__currentLoopData = $explode_custom_amounts ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="listItem" data-amount="<?php echo e($amount); ?>"><?php echo e(amount_with_currency_symbol($amount)); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>

                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.error-msg','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('error-msg'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                        <form action=" <?php echo e(route('tenant.frontend.donation.payment.form')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                        <input type="hidden" name="donation_id" value="<?php echo e($donation->id); ?>">

                        <div class="col-lg-12 col-md-12">
                            <label class="catTittle"> <?php echo e(__('Amount')); ?></label>
                            <div class="input-form input-form2">
                                <input type="number" name="amount" placeholder="" min="1" value="<?php echo e($default_amount_without_currency); ?>" class="left_default_amount">
                            </div>
                        </div>

                        <div class="col-lg-12 col-md-12">
                            <label class="catTittle"> <?php echo e(__('Name')); ?></label>
                            <div class="input-form input-form2">
                                <input type="text" name="name" placeholder="Enter your name" value="<?php echo e($auth_user->check() ? $auth_user->user()->name : ''); ?>">
                            </div>
                        </div>

                        <div class="col-lg-12 col-md-12">
                            <label class="catTittle"> <?php echo e(__('Email')); ?></label>
                            <div class="input-form input-form2">
                                <input type="email" name="email" placeholder="Enter your email" value="<?php echo e($auth_user->check() ? $auth_user->user()->email : ''); ?>">
                            </div>
                        </div>

                        <div class="col-sm-12">
                            <div class="order-form mt-20 mb-40">
                                <?php echo render_payment_gateway_for_form(); ?>

                                    <div class="form-group manual_payment_transaction_field d-none">
                                        <label class="label mb-2"><?php echo e(__('Attach Your Bank Document')); ?></label>
                                        <input class="form-control btn btn-warning btn-sm" type="file" name="manual_payment_attachment">
                                        <span class="help-info mt-3"><?php echo get_manual_payment_description(); ?></span>
                                    </div>
                            </div>
                        </div>

                        <div class="col-sm-12">
                            <div class="btn-wrapper">
                                <button type="submit" class="cmn-btn1 hero-btn"><?php echo e(__('Donate Now')); ?> <i class="fas fa-heart icon ZoomTwo"></i></button>
                            </div>
                        </div>

                        </form>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-5 col-md-6">
                    <div class="paymentDetails mb-24">
                        <h4 class="priceTittle mb-30"><?php echo e(__('Your Donation Details')); ?></h4>
                        <div class="donationPostUser mb-30">
                            <?php echo render_image_markup_by_attachment_id($donation->image); ?>

                            <div class="cap">
                                <a href="#" class="tittle"><?php echo e($donation->getTranslation('title',get_user_lang())); ?></a>
                                <p><?php echo e($donation->creator?->name); ?></p>
                            </div>
                        </div>
                        <div class="priceListing">
                            <ul class="listing">
                                <li class="listItem"><p class="leftCap"><?php echo e(__('Your Donation')); ?></p> <p class="rightCap total_donation_amount">??</p></li>
                                <li class="listItem"><p class="leftCap rightCap"><?php echo e(__('Total')); ?></p> <p class="rightCap total_donation_amount">??</p></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function(){

            let price_right_parent = $('.priceListing');
            let left_default_amount = $('.left_default_amount').val();
                price_right_parent.find('.total_donation_amount').text('<?php echo e(site_currency_symbol()); ?>'+ left_default_amount);

                $(document).on('click','.selectPricing li',function(){
                    let el = '<?php echo e(site_currency_symbol()); ?>' + $(this).data('amount');
                    price_right_parent.find('.total_donation_amount').text(el);
                    $('.left_default_amount').val($(this).data('amount'))
                });

            $(document).on('keyup','.left_default_amount ',function(){
                let el = $(this).val();
                price_right_parent.find('.total_donation_amount').text('<?php echo e(site_currency_symbol()); ?>'+ el);
            });

            $(document).on('click','.payment-gateway-list .single-gateway-item',function(){
                $('#slected_gateway_from_helper').val($(this).data('gateway'))

                let gateway = $(this).data('gateway');

                if (gateway == 'manual_payment') {
                    $('.manual_payment_transaction_field').removeClass('d-none');
                } else {
                    $('.manual_payment_transaction_field').addClass('d-none');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('tenant.frontend.frontend-page-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/multipurposesass/public_html/core/resources/views/themes/portfolio/frontend/donation/donation-payment/payment.blade.php ENDPATH**/ ?>