

<ul class="cart-icon">
    <?php if($product->inventory_detail_count < 1): ?>
        <li class="lisItem" title="<?php echo e(__('Add to Cart')); ?>">
            <a class="icon add-to-cart-btn" data-product_id="<?php echo e($product->id); ?>" href="javascript:void(0)">
                <i class="flaticon-shopping-cart icon"></i>
            </a>
        </li>


        <li class="lisItem" title="<?php echo e(__('Add to Wishlist')); ?>">
            <a class="add-to-wishlist-btn" data-product_id="<?php echo e($product->id); ?>" href="javascript:void(0)">
                <i class="flaticon-like icon"></i>
            </a>
        </li>

        <li class="lisItem" title="<?php echo e(__('Add to Compare')); ?>">
            <a class="cart-loading compare-btn" data-product_id="<?php echo e($product->id); ?>" href="javascript:void(0)">
                <i class="flaticon-compare icon"></i>
            </a>
        </li>

    <?php else: ?>
        <li class="lisItem" title="<?php echo e(__('Add to Cart')); ?>">
            <a class="icon cart-loading product-quick-view-ajax" href="javascript:void(0)" data-action-route="<?php echo e(route('tenant.products.single-quick-view', $product->slug)); ?>">
                <i class="flaticon-shopping-cart icon"></i>
            </a>
        </li>

        <li class="lisItem wishlist-btn" title="<?php echo e(__('Add to Wishlist')); ?>">
            <a class="cart-loading product-quick-view-ajax" href="javascript:void(0)" data-action-route="<?php echo e(route('tenant.products.single-quick-view', $product->slug)); ?>">
                <i class="flaticon-like icon"></i>
            </a>
        </li>

        <li class="lisItem" data-bs-toggle="tooltip" data-bs-placement="top"
            title="<?php echo e(__('Add to Compare')); ?>">
            <a class="cart-loading product-quick-view-ajax" href="javascript:void(0)" data-action-route="<?php echo e(route('tenant.products.single-quick-view', $product->slug)); ?>">
                <i class="flaticon-compare icon"></i>
            </a>
        </li>
    <?php endif; ?>



    <?php
        $image_array = array();
        $img = get_attachment_image_by_id($product->image_id);
        array_push($image_array, $img['img_url'] ?? []);

        if (count($product->gallery_images) > 0) {
            foreach ($product->gallery_images ?? [] as $image)
                {
                    $img = get_attachment_image_by_id($image->id);
                    array_push($image_array, $img['img_url']);
                }
        }
    ?>
    <li class="lisItem">
        <a class="icon cart-loading product-quick-view-ajax" href="javascript:void(0)" data-action-route="<?php echo e(route('tenant.products.single-quick-view', $product->slug)); ?>">
            <i class="las la-eye"></i></a>
    </li>
</ul>

<?php /**PATH /home/multipurposesass/public_html/core/Modules/Product/Resources/views/frontend/shop/partials/product-options.blade.php ENDPATH**/ ?>