<?php $user_select_lang_slug = \App\Facades\GlobalLanguage::user_lang_slug(); ?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e(get_static_option('site_'.$user_select_lang_slug.'_title')); ?> - <?php echo e(get_static_option('site_'.$user_select_lang_slug.'_tag_line')); ?></title>
    <link rel="preconnect" href="https://fonts.gstatic.com"> <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400,700&display=swap" rel="stylesheet">
    <?php echo render_favicon_by_id(get_static_option('site_favicon')); ?>

    <link rel="stylesheet" href="<?php echo e(global_asset('landlord/frontend/css/helpers.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(global_asset('landlord/frontend/css/errors.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/landlord/frontend/css/landing.css')); ?>">


    <style>
        *{
            font-family: Roboto, sans-serif;
        }
        .error-area-wrapper {
            padding: 110px 0;
        }
        .error-area-wrapper .img-box {
            text-align: center;
        }
        .error-area-wrapper .img-box .title {
            margin-bottom: 30px;
            font-size: 32px;
            line-height: 36px;
            font-weight: 700;
        }
        .error-area-wrapper .content {
            margin-top: 40px;
            text-align: center;
        }
        .error-area-wrapper .btn-default {
            display: inline-block;
            background-color: #f9d371;
            border: none;
            padding: 10px 30px;
            color: #333;
            transition: all 300ms;
            text-decoration: none;
        }

        .error-area-wrapper  .btn-default:hover {
            background-color: #333;
            color: #fff;
        }
        .main_heading {
            font-size: 200px;
            line-height: 200px;
            margin: 0;
        }


        .notfound-404 h2 {
            font-size: 36px;
            line-height: 40px;
            margin-bottom: 0;
        }

        @media screen and (max-width: 991px) {
            .error-area-wrapper {
                padding: 70px 0;
            }
            .main_heading {
                font-size: 100px;
                line-height: 100px;
                margin: 0;
            }
        }

    </style>

</head>

<body>
<div class="error-area-wrapper" data-padding-top="100" data-padding-bottom="100">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 ">
                <div class="notfound-404">

                    <?php if(isset($message)): ?>
                        <div class="content justify-content-center">

                            <h1 class="main_heading"><?php echo e(__('403')); ?></h1>
                            <h2 class="text-center"><?php echo e($message); ?></h2>

                                <div class="content">
                                    <div class="btn-wrapper">
                                        <a href="<?php echo e(url('/')); ?>" class="btn-default"><?php echo e(get_static_option('error_404_page_'.$user_select_lang_slug.'_button_text',__('Back to home'))); ?></a>
                                    </div>
                                </div>
                        </div>
                    <?php else: ?>

                        <?php
                            $route_sufix = tenant() ? 'dashboard' : 'home';
                        ?>

                        <div class="content">
                            <h1 class="main_heading"><?php echo e(__('500')); ?></h1>
                            <h2><?php echo e(__('Server side error!')); ?></h2>
                                <p><?php echo e(__('please inform site admin about the issue.')); ?></p>

                                <div class="content">
                                    <div class="btn-wrapper">
                                        <a href="<?php echo e(route(route_prefix().'admin.'.$route_sufix)); ?>" class="btn-default"><?php echo e(get_static_option('error_404_page_'.$user_select_lang_slug.'_button_text',__('Back to home'))); ?></a>
                                    </div>
                                </div>
                        </div>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    </div>
</div>

</body>
</html>


<?php /**PATH /home/multipurposesass/public_html/core/resources/views/errors/500.blade.php ENDPATH**/ ?>