
<!doctype html>
<html dir="<?php echo e(\App\Facades\GlobalLanguage::user_lang_dir()); ?>" lang="<?php echo e(\App\Facades\GlobalLanguage::user_lang_slug()); ?>">
<head>
    <meta charset="UTF-8">
    <title><?php echo e(__('Appointment Booking Invoice')); ?></title>
    <style type="text/css">
        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table {
            font-size: x-small;
        }
        td  {
            font-size: 14px;
            padding: 5px;
            vertical-align: middle !important;
        }
        table tr th {
            line-height: 20px;
            font-size: 14px;
            font-weight: 700;
            padding: 5px 5px;
        }
        tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }
        .gray {
            background-color: lightgray
        }
        .table-footer tr td {
            text-align: left;
            font-size: 14px;
            padding: 5px;
        }
        .table-top td p,
        .table-footer td p {
            line-height: 18px;
            display: block;
            padding: 5px 0;
        }
        .totalAmount {
            font-width: 700;
            font-size: 25px;
            text-align: right;
            display: block;
        }
        table thead tr th {
            border: 0;
        }
        table thead tr th {
            border: 0;
        }
        table thead tr th:first-child {
            text-align: left;
            padding: 10px 30px;
        }
        table thead tr th:last-child {
            text-align: right;
            padding: 10px 30px;
        }
        .borderStyle{
            margin-bottom: 5px;
        }
        .border-top{ border-top: 2px solid #000;}

        .singleItems{
            font-size: 14px;
        }

    </style>
</head>
<body>


<table width="100%" class="table-top">
    <tr>
        <td valign="top">
            <?php
                $logo = get_attachment_image_by_id(get_static_option('site_logo'));
            ?>
            <img src="<?php echo e($logo['img_url']); ?>" alt="" width="150"/>
        </td>
    </tr>

    <tr>
        <td valign="top">
            <p><strong><?php echo e(__('Date')); ?></strong>: <?php echo e(date('d-m-Y',strtotime($appointment_details->created_at))); ?></p>
            <p><strong><?php echo e(__('From')); ?></strong>: <?php echo e(get_static_option('tenant_site_global_email')); ?></p>
            <p><strong><?php echo e(__('To')); ?></strong>: <?php echo e($appointment_details->name); ?></p>
            <p><strong><?php echo e(__('User Email')); ?></strong>: <?php echo e($appointment_details->email); ?></p>
        </td>


        <td align="right">
            <h3><?php echo e(get_static_option('company_name')); ?></h3>
            <p><?php echo e(get_static_option('company_address')); ?></p>
            <p><?php echo e(get_static_option('company_email')); ?></p>
            <p><?php echo e(get_static_option('company_phone')); ?></p>
        </td>
    </tr>
</table>

<table class="table-footer" width="100%">
    <thead style="background-color: #353935; color: white">
    <tr>
        <th><?php echo e(__('Description')); ?></th>
        <th><?php echo e(__('Additional Services')); ?></th>
        <th><?php echo e(__('Amount')); ?></th>
    </tr>
    </thead>
    <tbody>
    <tr>
        <td valign="top">
            <div>
                <p class="singleItems"><strong><?php echo e(__('Appointment Title')); ?></strong>: <?php echo e(optional($appointment_details->appointment)->getTranslation('title',get_user_lang())); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Appointment Date')); ?></strong>: <?php echo e($appointment_details->appointment_date); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Appointment Time')); ?></strong>: <?php echo e($appointment_details->appointment_time); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Appointment Price')); ?></strong>: <?php echo e(amount_with_currency_symbol($appointment_details->appointment_price)); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Payment Gateway')); ?></strong>: <?php echo e(str_replace('_',' ',ucfirst($appointment_details->payment_gateway))); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Payment Status')); ?></strong>: <?php echo e($appointment_details->payment_status); ?></p>
                <p class="singleItems"><strong><?php echo e(__('Transaction ID')); ?></strong>: <?php echo e($appointment_details->transaction_id); ?></p>

            </div>
        </td>


<td class="middle">
    <?php if(count($appointment_details->sub_appointment_log_items) > 0): ?>
        <?php $__currentLoopData = $appointment_details->sub_appointment_log_items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_orders): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <p class="singleItems"><strong><?php echo e(__('Title')); ?></strong>: <?php echo e($sub_orders->title); ?></p>
            <p class="singleItems"><strong><?php echo e(__('Price')); ?></strong>: <?php echo e(amount_with_currency_symbol($sub_orders->price)); ?></p>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
</td>

        <td align="right">
            <div class="borderStyle">
                <h6 class="singleItems" ><strong><?php echo e(__('Appointment Subtotal')); ?></strong>: <?php echo e(amount_with_currency_symbol($appointment_details->subtotal)); ?></h6>
                <h6 class="singleItems" ><strong><?php echo e(__('Tax')); ?></strong>: <?php echo e(amount_with_currency_symbol(get_appointment_tax_amount($appointment_details->appointment_id,$appointment_details->subtotal))); ?></h6>
                <h2 class=" border-top" ><strong><?php echo e(__('Total Amount')); ?>: </strong> <?php echo e(amount_with_currency_symbol($appointment_details->total_amount)); ?></h2>
            </div>
        </td>
    </tr>
    </tbody>

</table>





<?php /**PATH /home/multipurposesass/public_html/core/resources/views/tenant/frontend/invoice/appointment.blade.php ENDPATH**/ ?>