<?php $__env->startSection('title'); ?>
   <?php echo e(__('Donation Payment Logs')); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('section'); ?>

    <?php if(count($all_user_donation) > 0): ?>
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                <tr>
                    <th scope="col"><?php echo e(__('Donation Order Info')); ?></th>
                    <th scope="col"><?php echo e(__('Payment Status')); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $all_user_donation; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <div class="user-dahsboard-order-info-wrap">
                                <h5 class="title"><?php echo e($data->donation?->getTranslation('title',get_user_lang())); ?></h5>
                                <div class="div">
                                    <small class="d-block"><strong><?php echo e(__('Order ID:')); ?></strong> #<?php echo e($data->id); ?></small>
                                    <small class="d-block"><strong><?php echo e(__('Donation Price:')); ?></strong> <?php echo e(amount_with_currency_symbol($data->amount)); ?></small>
                                    <small class="d-block"><strong><?php echo e(__('Payment Gateway')); ?> : </strong> <?php echo e($data->payment_gateway); ?></small>
                                    <small class="d-block"><strong><?php echo e(__('Date:')); ?></strong> <?php echo e(date_format($data->created_at,'D m Y')); ?></small>
                                    <?php if($data->status == 1): ?>
                                        <form action="<?php echo e(route('tenant.frontend.donation.invoice.generate')); ?>"  method="post">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="id" id="invoice_generate_order_field" value="<?php echo e($data->id); ?>">
                                            <button class="btn btn-secondary btn-xs btn-small margin-top-10" type="submit"><?php echo e(__('Invoice')); ?></button>
                                        </form>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>

                        <td>
                            <?php if($data->status != 1): ?>
                                <span class="text-capitalize alert-sm"><?php echo e($data->payment_status); ?></span>
                                <span class="alert alert-warning text-capitalize donation_status d-inline-block" ><?php echo e(\App\Enums\DonationPaymentStatusEnum::getText($data->status)); ?></span>
                                <a href="<?php echo e(route('tenant.frontend.donation.payment',$data->donation_id)); ?>" class="btn btn-success btn-sm my-2" target="_blank"><?php echo e(__('Pay Now')); ?></a>

                            <?php else: ?>
                                <span class="alert alert-success text-capitalize donation_status d-inline-block" ><?php echo e(\App\Enums\DonationPaymentStatusEnum::getText($data->status)); ?></span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="blog-pagination">
            <?php echo e($all_user_donation->links()); ?>

        </div>
    <?php else: ?>
        <div class="alert alert-warning"><?php echo e(__('No Order Found')); ?></div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('tenant.frontend.user.dashboard.user-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/multipurposesass/public_html/core/resources/views/tenant/frontend/user/dashboard/donation-logs.blade.php ENDPATH**/ ?>