

<?php if(Auth::guard('web')->check()): ?>

    <div id="reviews">
    <div class="single-details-tab">
        <div class="review-form my-5">
            <h3><?php echo e(__('Leave a Review')); ?></h3>
            <form>
                <input type="hidden" class="rating-count" value="">
                <div class="ratings mt-4">
                    <select class="star-rating">
                        <option value="5"><?php echo e(__('Excellent')); ?></option>
                        <option value="4"><?php echo e(__('Very Good')); ?></option>
                        <option value="3" selected><?php echo e(__('Average')); ?></option>
                        <option value="2"><?php echo e(__('Poor')); ?></option>
                        <option value="1"><?php echo e(__('Terrible')); ?></option>
                    </select>
                </div>

                <div class="form-group mt-4">
                    <textarea rows="8" type="text" name="review_text" class="form-control review-text" id="review-text"></textarea>
                </div>

                <div class="btn-wrapper text-end mt-4">
                    <button type="submit" id="review-submit-btn" class="cmn-btn btn-small cmn-btn-bg-2 radius-0"><?php echo e(__('Submit Review')); ?></button>
                </div>
            </form>
        </div>

        <div class="tab-review">
            <div class="all-reviews">
                <?php $__currentLoopData = $product->reviews->take(5) ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="about-seller-flex-content">
                        <div class="about-seller-thumb">
                            <a href="javascript:void(0)">
                                <?php echo render_image_markup_by_attachment_id($review?->user?->image); ?>

                            </a>
                        </div>

                        <div class="about-seller-content">
                            <h5 class="title fw-500">
                                <a href="javascript:void(0)"> <?php echo e($review?->user?->name); ?> </a>
                            </h5>

                            <?php echo render_star_rating_markup($review->rating); ?>


                            <p class="about-review-para"> <?php echo e($review->review_text); ?> </p>
                            <span class="review-date"> <?php echo e($review->created_at?->diffForHumans()); ?> </span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="btn-wrapper mt-4">
                <a href="javascript:void(0)" class="cmn-btn btn-small cmn-btn-bg-2 radius-0 see-more-review" data-items="5"> <?php echo e(__('See More')); ?> </a>
            </div>
        </div>
    </div>
</div>
<?php else: ?>
    <section class="loginArea section-padding2">
        <div class="container">
            <div class="row justify-content-center">

                <div class="col-xxl-6 col-xl-7 col-lg-9">
                    <form action="#" class="form-Wrapper" id="login_form_order_page">
                        <div class="row">

                            <div class="col-lg-12">
                                <div class="section-tittle section-tittle2 text-center mb-30">
                                    <h2 class="tittle p-0"><?php echo e(__('Login in your ')); ?><span class="color"> <?php echo e(__('Account')); ?></span></h2>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12">
                                <div class="error-wrap"></div>
                                <div class="input-form input-form2">
                                    <input type="text" name="username" placeholder="Enter your username">
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12">
                                <div class="input-form input-form2">
                                    <input type="password" name="password" placeholder="Password">
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="passRemember">
                                    <label class="checkWrap2"><?php echo e(__('Remember me')); ?>

                                        <input class="effectBorder" type="checkbox" value="">
                                        <span class="checkmark"></span>
                                    </label>
                                    <!-- forgetPassword -->
                                    <div class="forgetPassword mb-25">
                                        <a href="<?php echo e(route('tenant.user.forget.password')); ?>" class="forgetPass"><?php echo e(__('Forget passwords?')); ?></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="btn-wrapper text-center mt-20">
                                    <button type="button" id="login_btn" class="cmn-btn1 w-100 mb-40"><?php echo e(__('Login')); ?></button>

                                    <p class="sinUp mb-20"><span><?php echo e(__('Don’t have an account ?')); ?> </span>
                                        <a href="<?php echo e(route('tenant.user.register')); ?>" class="singApp"><?php echo e(__('Sign Up')); ?></a>
                                    </p>

                                    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.social-login-markup','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('social-login-markup'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH /home/multipurposesass/public_html/core/Modules/Product/Resources/views/frontend/shop/product_details/partials/product-reviews.blade.php ENDPATH**/ ?>