
<div class="single-shop-details-wrapper padding-left-50">
    <?php if($campaign_product !== null && $campaign_product->status !== 'draft' && ($product?->inventory?->stock_count > 0)): ?>
        <div class="campaign_countdown_wrapper mb-5">
            <h3 class="text-capitalize text-start mb-3"><?php echo e($campaign_name); ?></h3>

            <?php if($is_expired): ?>
                <div class="global-timer"></div>
            <?php else: ?>
                <div class="text-capitalize alert alert-warning">
                    <h5><?php echo e(__('The Campaign is over or not yet started')); ?></h5>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <div class="name_badge">
        <h2 class="tittle"> <?php echo e($product->name); ?></h2>
    </div>

    <?php echo render_product_star_rating_markup_with_count($product); ?>


    <div class="productPrice">
        <span class="regularPrice flash-prices"
              data-main-price="<?php echo e($sale_price); ?>"
              data-currency-symbol="<?php echo e(site_currency_symbol()); ?>"
              id="<?php echo e($quickView ? "quick-view-price" : "price"); ?>"> <?php echo e(amount_with_currency_symbol($sale_price)); ?></span>
        <span class="offerPrice"><?php echo e($deleted_price != null ? amount_with_currency_symbol($deleted_price) : ''); ?></span>
    </div>

    <div class="value-input-area">
        <?php if($productSizes->count() > 0 && !empty(current(current($productSizes)))): ?>
            <div class="value-input-area single-input-list mt-4 size_list  <?php echo e($quickView ? "quick-view-value-input-area" : ""); ?>">
                    <span class="input-title fw-500 color-heading">
                        <strong class="color-light"> <?php echo e(__('Size:')); ?> </strong>
                        <input readonly class="form--input value-size" name="size" type="text" value="">
                        <input type="hidden" id="selected_size">
                    </span>
                <ul class="size-lists select-list <?php echo e($quickView ? "quick-view-size-lists" : ""); ?>" data-type="Size">
                    <?php $__currentLoopData = $productSizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(!empty($product_size)): ?>
                            <li class="list"
                                data-value="<?php echo e(optional($product_size)->id); ?>"
                                data-display-value="<?php echo e(optional($product_size)->name); ?>"
                            > <?php echo e(optional($product_size)->size_code); ?> </li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <?php if($productColors->count() > 0 && current(current($productColors))): ?>
            <div
                class="value-input-area single-input-list mt-4 color_list  <?php echo e($quickView ? "quick-view-value-input-area" : ""); ?>">
                    <span class="input-title fw-500 color-heading">
                        <strong class="color-light"> <?php echo e(__('Color:')); ?> </strong>
                        <input readonly class="form--input value-size" name="color" type="text" value="">
                        <input type="hidden" id="selected_color">
                    </span>
                <ul class="size-lists color-list <?php echo e($quickView ? "quick-view-size-lists" : ""); ?>" data-type="Color">
                    <?php $__currentLoopData = $productColors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(!empty($product_color)): ?>
                            <li style="background-color: <?php echo e($product_color->color_code); ?>"
                                data-value="<?php echo e(optional($product_color)->id); ?>"
                                data-display-value="<?php echo e(optional($product_color)->name); ?>"
                            ></li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>


        <?php $__currentLoopData = $available_attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute => $options): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="value-input-area single-input-list mt-4 attribute_options_list  <?php echo e($quickView ? "quick-view-value-input-area" : ""); ?>">
                        <span class="input-title fw-500 color-heading input-list">
                            <strong class="color-light"> <?php echo e($attribute); ?> </strong>
                            <input readonly class="form--input value-size" type="text" value="">
                            <input type="hidden" id="selected_attribute_option" name="selected_attribute_option">
                        </span>
                <ul class="size-lists <?php echo e($quickView ? "quick-view-size-lists" : ""); ?>" data-type="<?php echo e($attribute); ?>">
                    <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="list"
                            data-value="<?php echo e($option); ?>"
                            data-display-value="<?php echo e($option); ?>"
                        > <?php echo e($option); ?> </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="quantity-area mt-4">
        <div class="quantity-flex mb-30">
            <div class="countWrap styleTwo mr-10">
              <div class="numberCount product-quantity">
                  <div class="value-button minus decrease <?php echo e($quickView ? "quick-view-" : ""); ?>substract substract"><i class="las la-minus"></i></div>
                   <input class="<?php echo e($quickView ? "quick-view-" : ""); ?>quantity-input quantity-input qty_" type="number"
                       id="<?php echo e($quickView ? "quick-view-" : ""); ?>quantity" name="quantity" value="1">
                  <div class="value-button plus increase <?php echo e($quickView ? "quick-view-" : ""); ?>plus plus"><i class="las la-plus"></i></div>
              </div>
           </div>
            <?php
                if ($product?->inventory?->stock_count > 0)
                    {
                        $text_color = 'text-success';
                        $text = __('Stock Available');
                    } else {
                        $text_color = 'text-danger';
                        $text = __('Stock Out');
                    }
            ?>

            <span class="stock-available color-stock stock-available color-stock <?php echo e($text_color); ?>" id="<?php echo e($quickView ? "quick_view_" : ""); ?>item_left">
                <?php echo e($text); ?>

                <span class="color-paragraph"> (<?php echo e($product?->inventory?->stock_count); ?>) </span>
            </span>
        </div>

        <div class="quantity-btn mt-4">
            <ul class="cartList">
                <li class="listItem">

               <a href="javascript:void(0)" class="<?php echo e($quickView ? "quick_view_add_to_wishlist" : "add_to_wishlist_single_page"); ?> btn-wishlist share-icon">
                    <span class="icon">
                       <button type="button" class="items"><i class="lar la-heart icon"></i></button>
                    </span>
                    </a>
              </li>

                <li class="listItem">
                    <a href="javascript:void(0)"
                       class="items btn-wishlist share-icon fw-500 <?php echo e($quickView ? "quick-view-" : ""); ?>compare-btn"
                       data-product_id="<?php echo e($product->id); ?>"
                       data-bs-toggle="tooltip"
                       data-bs-placement="top"
                       title="<?php echo e(__('Add to Compare')); ?>">
                    <span class="icon">
                        <i class="las la-retweet icon"></i>
                    </span>
                    </a>

                </li>

                <li class="listItem"> <button type="button" class="items <?php echo e($quickView ? "quick_view_add_to_cart" : "add_to_cart_single_page"); ?>

                    cmn-btn cmn-btn-bg-heading cart-loading"><i class="flaticon-shopping-cart icon"></i></button>
                </li>

                <li class="listItem">
                    <div class="btn-wrapper">
                        <a href="#!" data-product_id="<?php echo e($product->id); ?>" class="<?php echo e($quickView ? "quick_view_but_now" : "buy_now_single_page"); ?> buy_now_single_pagecmn-btn cmn-btn4 cart-loading"> <?php echo e(__('Buy Now')); ?> </a>
                    </div>
                </li>

            </ul>

        </div>

    </div>
    <div class="wishlist-compare mt-4">
        <div class="wishlist-share social_share_parent">
            <?php
                $product_primary_image = get_attachment_image_by_id($product->image_id);
                $product_primary_image = $product_primary_image ? $product_primary_image['img_url'] : '';
            ?>
            <ul class="social_share_wrapper_item d-inline-flex">
                <?php echo single_post_share(route('tenant.shop.product.details',$product->slug), $product->name, $product_primary_image); ?>

            </ul>
        </div>
    </div>
    <div class="shop-details-stock shop-border-top pt-4 mt-4">
        <ul class="stock-category">
            <li class="category-list">
                <span class="list-item fw-600">
                    <?php
                        $category_route_con = !empty($product?->category?->slug) ? route('tenant.shop.category.products', ['category' ,$product?->category?->slug]) : '';
                        $subcategory_route_con = !empty($product?->category?->slug) ? route('tenant.shop.category.products', ['subcategory' ,$product?->subCategory?->slug]) : '';
                    ?>

                    <a href="<?php echo e($category_route_con); ?>"><?php echo e($product?->category?->name); ?></a>
                    |
                    <a href="<?php echo e($subcategory_route_con); ?>"><?php echo e($product?->subCategory?->name); ?></a>
                    |
                    <?php $__currentLoopData = $product->childCategory ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $child_catroute_con = !empty($child_category?->slug) ? route('tenant.shop.category.products', ['child-category' ,$child_category?->slug]) : '';
                        ?>
                        <a href="<?php echo e($child_catroute_con); ?>"> <?php echo e($child_category->name); ?> </a>

                        <?php if(!$loop->last): ?>
                            ,
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </span>
            </li>
            <?php if($product->uom != null): ?>
                <li class="category-list">
                    <span> <?php echo e(__('Unit:')); ?> </span>
                    <a class="list-item fw-600" href="javascript:void(0)">
                        <span><?php echo e($product?->uom?->quantity); ?></span>
                        <span><?php echo e($product?->uom?->uom_details?->name); ?></span>
                    </a>
                </li>
            <?php endif; ?>
            <li class="category-list">
                <span> <?php echo e(__('SKU:')); ?> </span>
                <a class="list-item fw-600" href="javascript:void(0)"> <?php echo e($product?->inventory?->sku); ?> </a>
            </li>
        </ul>
        <div class="delivery-options delivery-parent mt-4">
            <?php if($product->product_delivery_option != null): ?>
                <?php $__currentLoopData = $product->product_delivery_option; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="delivery-item d-flex">
                        <div class="icon">
                            <i class="<?php echo e($option->icon); ?>"></i>
                        </div>
                        <div class="content">
                            <h6 class="title"><?php echo e($option->title); ?></h6>
                            <p><?php echo e($option->sub_title); ?></p>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH /home/multipurposesass/public_html/core/Modules/Product/Resources/views/frontend/shop/product_details/partials/product-options.blade.php ENDPATH**/ ?>