<?php $__env->startSection('title'); ?>
    <?php echo e($order_details->getTranslation('title',get_user_lang())); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Plan Details')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>

    <link rel="stylesheet" href="<?php echo e(global_asset('assets/common/css/toastr.css')); ?>">

    <style>
        .theme-wrapper{
            border: 1px solid transparent;
            outline: 1px solid transparent;
        }
        .selected_theme{
            transition: 0.3s;
            border-color: var(--main-color-two);
            outline-color: var(--main-color-two);
            padding: 10px;
        }
        .selected_text{
            top: 0;
            left: 11px;
            background-color: var(--main-color-two);
            padding: 15px;
            position: absolute;
            color: white;
            transition: 0.3s;
        }
        .selected_text i{
            font-size: 30px;
        }
        .selected_text i {
            background: darkslateblue;
            font-size: 30px;
        }

        #login_form_order_page .form-control{
            height: 50px;
            margin-bottom: 10px;
        }

        .parent_domain{
            margin-left: 100px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php
        $user_lang = get_user_lang();
        $user = \Auth::guard('web')->user();
    ?>
    <section class="order-service-page-content-area padding-100">
        <div class="container">

            <div class="row margin-bottom-100">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                    <h3><?php echo e(__('Select Theme')); ?></h3>
                    <div class="row theme-row g-4 row-cols-1 row-cols-sm-2 row-cols-lg-3 row-cols-xl-4 row-cols-xl-4 mt-2">
                        <?php $__currentLoopData = $themes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $theme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php
                              $check_theme_permission = $order_details->plan_features?->pluck('feature_name')->toArray();

                              if($theme->is_available == 0 || ($theme->theme_code == 'eCommerce' && !in_array("eCommerce", $check_theme_permission))){
                                  continue ;
                              }

                              $default_admin_set = get_static_option_central('landlord_default_theme_set');
                              $selected_condition_if_default = $theme->theme_code == $default_admin_set ? 'selected_theme' : '';
                              $selected_condition_normal = $loop->first ? 'selected_theme' : '';
                              $final_condition =  $selected_condition_if_default ?? $selected_condition_normal
                            ?>

                            <div class="col position-relative view_page_theme">
                                <div class="theme-wrapper <?php echo e($final_condition); ?>" data-theme="<?php echo e($theme->slug); ?>" data-name="<?php echo e($theme->getTranslation('title', $user_lang)); ?>">
                                    <?php echo render_image_markup_by_attachment_id($theme->image); ?>

                                    <h4 class="text-center title"><?php echo e($theme->getTranslation('title', $user_lang)); ?></h4>

                                    <?php if($theme->theme_code == $default_admin_set): ?>
                                        <h4 class="selected_text"><i class="las la-check-circle"></i></h4>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

            <div class="row justify-content-center ">
                <div class="col-xl-6 col-lg-8">
                    <div class="section-title margin-bottom-60">
                        <h2 class="title"><?php echo e($order_details->getTranslation('title',$user_lang)); ?></h2>
                    </div>
                </div>
            </div>

            <div class="row justify-content-center">
                <div class="col-xl-3 col-lg-4 col-md-5 col-sm-8">
                    <div class="price-plan-left-wrap">
                        <div class="price-header">
                            <h3 class="title"></h3>
                            <div class="price-wrap">
                                <span class="price"><?php echo e(amount_with_currency_symbol($order_details->price)); ?></span><br>
                                <span class=""><?php echo e(\App\Enums\PricePlanTypEnums::getText($order_details->type)); ?></span>
                            </div>
                        </div>
                        <div class="price-footer">
                            <?php if($trial): ?>
                                <?php
                                    if(Auth::guard('web')->check() != true)
                                        {
                                            $button_attr = 'data-bs-target="#loginModal"';
                                        } else {
                                            $button_attr = 'data-bs-target="#trialModal"';
                                        }
                                ?>
                                <div class="btn-wrapper">
                                    <a href="javascript:void(0)" class="cmn-btn02"
                                       data-bs-toggle="modal" <?php echo $button_attr; ?>><?php echo e(__('Start Trial')); ?></a>
                                </div>

                           <?php elseif($order_details->price == 0): ?>
                                 <div class="btn-wrapper">
                                    <a href="<?php echo e(route('landlord.frontend.plan.order',$order_details->id)); ?>"
                                       class="cmn-btn02"><?php echo e(__('Get Now')); ?></a>
                                </div>

                            <?php else: ?>
                                <div class="btn-wrapper">
                                    <a href="<?php echo e(route('landlord.frontend.plan.order',$order_details->id)); ?>"
                                       class="cmn-btn02"><?php echo e(__('Buy Now')); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-xl-9 col-lg-8 col-md-7 col-sm-8">
                    <div class="single-price-plan-item price-plan-two">

                        <div class="price-body features-view-all">
                            <ul class="features">
                                <?php if(!empty($order_details->page_permission_feature)): ?>
                                    <li class="check"> <?php echo e(sprintf(__('Page Create %d'),$order_details->page_permission_feature )); ?></li>
                                <?php endif; ?>

                                <?php if(!empty($order_details->product_create_permission)): ?>
                                    <li class="check"> <?php echo e(sprintf(__('Product Create %d'),$order_details->product_create_permission )); ?></li>
                                <?php endif; ?>

                                <?php if(!empty($order_details->campaign_create_permission)): ?>
                                    <li class="check"> <?php echo e(sprintf(__('Campaign Create %d'),$order_details->campaign_create_permission )); ?></li>
                                <?php endif; ?>

                                <?php if(!empty($order_details->blog_permission_feature)): ?>
                                    <li class="check"> <?php echo e(sprintf(__('Blog Create %d'),$order_details->blog_permission_feature )); ?></li>
                                <?php endif; ?>

                                <?php if(!empty($order_details->service_permission_feature)): ?>
                                    <li class="check"> <?php echo e(sprintf(__('Service Create %d'),$order_details->service_permission_feature )); ?></li>
                                <?php endif; ?>

                                <?php $__currentLoopData = $order_details->plan_features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="check"> <?php echo e(__(str_replace('_', ' ',ucfirst($item->feature_name))) ?? ''); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>

                    <?php
                        $faq_items = !empty($order_details->faq) ? unserialize($order_details->faq,['class' => false]) : ['title' => []];
                         $rand_number = rand(9999,99999999);
                    ?>

                    <?php if(!empty(current($faq_items['title'])) ): ?>
                        <section class="faqArea section-padding fix section-bg2">
                            <div class="row justify-content-center">
                                <div class="col-xl-12">
                                    <div class="section-tittle section-tittle2 mb-25">
                                        <h2 class="tittle wow fadeInUp" data-wow-delay="0.0s"><?php echo e(__('General')); ?><span class="color"> <?php echo e(__('Question')); ?> </span></h2>
                                    </div>
                                </div>
                            </div>
                            <div class="container">
                                <div class="row align-items-center justify-content-between">
                                    <div class="col-xl-12 col-lg-12 col-md-12">
                                        <div class="collapse-wrapper">
                                            <div class="accordion" id="accordionExample-<?php echo e($rand_number); ?>">
                                                <?php $__currentLoopData = $faq_items['title']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php
                                                        $aria_expanded = 'false';
                                                    ?>
                                                    <div class="accordion-item">
                                                        <h2 class="accordion-header" id="headingOne-<?php echo e($loop->index); ?>">
                                                            <button class="accordion-button <?php echo e($loop->index == 0 ? '' : 'collapsed'); ?>" type="button"
                                                                    data-bs-toggle="collapse"
                                                                    data-bs-target="#collapseOne-<?php echo e($loop->index); ?>"
                                                                    aria-expanded="<?php echo e($aria_expanded); ?>"
                                                                    aria-controls="collapseOne-<?php echo e($loop->index); ?>">
                                                                <?php echo e(purify_html($faq)); ?>

                                                            </button>
                                                        </h2>
                                                        <div id="collapseOne-<?php echo e($loop->index); ?>"
                                                             class="accordion-collapse collapse <?php echo e($loop->index == 0 ? 'show' : ''); ?>"
                                                             aria-labelledby="headingOne-<?php echo e($loop->index); ?>"
                                                             data-bs-parent="#accordionExample-<?php echo e($rand_number); ?>">
                                                            <div class="accordion-body">
                                                                <?php echo e(purify_html($faq_items['description'][$loop->index] ?? '')); ?>

                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                    <?php endif; ?>
                </div>
            </div>


        </div>
    </section>


    <div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="auth-form-light text-left justify-content-between">

                        <h4 class="text-center my-3 title"><?php echo e(__('Sign in to continue.')); ?></h4>
                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.error-msg','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('error-msg'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.flash-msg','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('flash-msg'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                        <form class="pt-3" action="" method="post" id="login_form_order_page">
                            <div id="msg-wrapper"></div>
                            <div class="error-wrap"></div>
                            <div class="form-group">
                                <input type="email" name="username" class="form-control"
                                       placeholder="<?php echo e(__('Username')); ?>">
                            </div>
                            <div class="form-group">
                                <input type="password" name="password" class="form-control"
                                       placeholder="<?php echo e(__('Password')); ?>">
                            </div>
                            <div class="mt-3">
                                <div class="btn-wrapper">
                                    <button type="button" class="cmn-btn1 w-100 mb-40" id="login_btn"><?php echo e(__('Login')); ?></button>
                                </div>

                            </div>
                            <div class="my-2 d-flex justify-content-between align-items-center">
                                <div class="form-check">
                                    <label class="form-check-label text-muted">
                                        <input type="checkbox" name="remember"
                                               class="form-check-input"> <?php echo e(__('Keep me signed in')); ?>

                                        <i class="input-helper"></i>
                                    </label>
                                </div>
                                <a href="#" class="auth-link text-black"><?php echo e(__('Forgot password?')); ?></a>
                            </div>
                            <div class="text-center mt-4 font-weight-light"> <?php echo e(__('Do not have an account?')); ?>

                                <a href="<?php echo e(route('landlord.user.register')); ?>" class="text-primary"><?php echo e(__('Create')); ?></a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if(Auth::guard('web')->check()): ?>
        <div class="modal fade" id="trialModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="text-center text-success" id="exampleModalLabel"><?php echo e(__('Start Trial')); ?></h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="error-wrap"></div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-6">
                                <h5><?php echo e(__('Personal Information')); ?></h5>
                                <hr>
                                <p><?php echo e(__('Name :')); ?><span><?php echo e($user->name); ?></span></p>
                                <p><?php echo e(__('Email :')); ?> <span><?php echo e($user->email); ?></span></p>

                                <p class="mt-4"><?php echo e(__('Subdomain :')); ?>

                                    <input class="form--control" type="text" name="subdomain" autocomplete="off" value="<?php echo e(old('subdomain')); ?>" placeholder="<?php echo e(__('Subdomain')); ?>">

                                </p>


                                <div id="subdomain-wrap"></div>

                            </div>

                            <?php
                                $default_theme_slug = get_static_option_central('landlord_default_theme_set');
                                $theme = \App\Models\Themes::where('theme_code',$default_theme_slug)->first();
                                $theme_name = __('Donation');
                                $theme_slug = 'theme-1';
                                if(!empty($theme)){
                                    $theme_name = $theme->title;
                                    $theme_slug = $theme->slug;
                                }
                            ?>

                            <div class="col-6">
                                <h5><?php echo e(__('Package Information')); ?></h5>
                                <hr>
                                <p><?php echo e(__('Plan :')); ?> <span><?php echo e($order_details->getTranslation('title', $user_lang)); ?></span></p>
                                <p><?php echo e(__('Price :')); ?> <span><?php echo e(amount_with_currency_symbol($order_details->price)); ?></span></p>
                                <p><?php echo e(__('Trial :')); ?> <span><?php echo e($order_details->trial_days); ?> <?php echo e(__('Days')); ?></span></p>
                                <p class="modal_theme"><?php echo e(__('Theme :')); ?> <span><?php echo e($theme_name); ?></span></p>
                            </div>

                            <form action="" class="mt-5" method="POST">
                                <input type="hidden" name="user_id" id="user-id" value="<?php echo e($user->id); ?>">
                                <input type="hidden" name="order_id" id="order-id" value="<?php echo e($order_details->id); ?>">
                                <input type="hidden" name="theme_slug" id="theme-slug" value="<?php echo e($theme_slug); ?>">

                                <div class="parent d-flex justify-content-end">
                                    <div class="btn-wrapper">
                                        <button type="button" id="create-trial-account-button" href="<?php echo e(route('landlord.frontend.plan.order',$order_details->id)); ?>"
                                                class="cmn-btn02"><?php if(auth('web')->check()): ?><?php echo e(__('Create Website')); ?> <?php else: ?> <?php echo e(__('Create Account')); ?> <?php endif; ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(global_asset('assets/common/js/toastr.min.js')); ?>"></script>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.unique-domain-checker','data' => ['name' => 'subdomain']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('unique-domain-checker'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('subdomain')]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
    <script>
        (function ($) {
            "use strict";
            $(document).ready(function ($) {


                $(document).on('click', '#order_pkg_btn', function () {
                    var name = $("#order_name").val()
                    var email = $("#order_email").val()
                    sessionStorage.pkg_user_name = name;
                    sessionStorage.pkg_user_email = email;

                })

                $(document).on('click', '#login_btn', function (e) {
                    e.preventDefault();
                    var formContainer = $('#login_form_order_page');
                    var el = $(this);
                    var username = formContainer.find('input[name="username"]').val();
                    var password = formContainer.find('input[name="password"]').val();
                    var remember = formContainer.find('input[name="remember"]').val();

                    el.text('<?php echo e(__("Please Wait")); ?>');

                    $.ajax({
                        type: 'post',
                        url: "<?php echo e(route('landlord.user.ajax.login')); ?>",
                        data: {
                            _token: "<?php echo e(csrf_token()); ?>",
                            username: username,
                            password: password,
                            remember: remember,
                        },
                        success: function (data) {
                            if (data.status == 'invalid') {
                                el.text('<?php echo e(__("Login")); ?>')
                                formContainer.find('.error-wrap').html('<div class="alert alert-danger">' + data.msg + '</div>');
                            } else {
                                formContainer.find('.error-wrap').html('');
                                el.text('<?php echo e(__("Login Success.. Redirecting ..")); ?>');
                                location.reload();
                            }
                        },
                        error: function (data) {
                            var response = data.responseJSON.errors
                            formContainer.find('.error-wrap').html('<ul class="alert alert-danger"></ul>');
                            $.each(response, function (value, index) {
                                formContainer.find('.error-wrap ul').append('<li>' + index + '</li>');
                            });
                            el.text('<?php echo e(__("Login")); ?>');
                        }
                    });
                });
                var defaulGateway = $('#site_global_payment_gateway').val();
                $('.payment-gateway-wrapper ul li[data-gateway="' + defaulGateway + '"]').addClass('selected');

                $(document).on('click', '.payment-gateway-wrapper > ul > li', function (e) {
                    e.preventDefault();

                    let gateway = $(this).data('gateway');
                    if (gateway === 'manual_payment') {
                        $('.manual_transaction_id').removeClass('d-none');
                    } else {
                        $('.manual_transaction_id').addClass('d-none');
                    }

                    $(this).addClass('selected').siblings().removeClass('selected');
                    $('.payment-gateway-wrapper').find(('input')).val($(this).data('gateway'));
                    $('.payment_gateway_passing_clicking_name').val($(this).data('gateway'));

                });

                $(document).on('change', '#guest_logout', function (e) {
                    e.preventDefault();
                    var infoTab = $('#nav-profile-tab');
                    var nextBtn = $('.next-step-button');
                    if ($(this).is(':checked')) {
                        $('.login-form').hide();
                        infoTab.attr('disabled', false).removeClass('disabled');
                        nextBtn.show();
                    } else {
                        $('.login-form').show();
                        infoTab.attr('disabled', true).addClass('disabled');
                        nextBtn.hide();
                    }
                });

                $(document).on('click', '.next-step-button', function (e) {
                    var infoTab = $('#nav-profile-tab');
                    infoTab.attr('disabled', false).removeClass('disabled').addClass('active').siblings().removeClass('active');
                    $('#nav-profile').addClass('show active').siblings().removeClass('show active');
                });

                $(document).on('click', '#create-trial-account-button', function (e) {
                    e.preventDefault();
                    var timer = "";
                    var submit_button = $('#create-trial-account-button');
                    var text = ["<?php echo e(__('Creating Account...')); ?>","<?php echo e(__('Creating Database...')); ?>","<?php echo e(__('Creating Designs...')); ?>","<?php echo e(__('Getting Ready...')); ?>","<?php echo e(__('Your Account is Ready...')); ?>"];

                    let i = 1;
                    function buttonLoop(isRunning) {
                        if(isRunning){
                            timer = setTimeout(function() {
                                submit_button.text(text[i]);
                                if (i < 5) {
                                    buttonLoop(true);
                                }
                                i++;
                            }, 1500)
                        }else{
                            clearTimeout(timer);
                        }
                    }

                    let user_id = $('#user-id').val();
                    let order_id = $('#order-id').val();
                    let subdomain = $('input[name=subdomain]').val();
                    let theme = $('input[name=theme_slug]').val();

                    let formContainer = $('.modal-body');

                    $.ajax({
                        type: 'post',
                        url: "<?php echo e(route('landlord.frontend.trial.account')); ?>",
                        data: {
                            _token: "<?php echo e(csrf_token()); ?>",
                            user_id: user_id,
                            order_id: order_id,
                            subdomain: subdomain,
                            theme: theme
                        },
                        beforeSend: function () {
                            submit_button.prop('disabled', true);
                            submit_button.text(text[0]);

                            buttonLoop(true);
                        },
                        success: function (data) {
                            buttonLoop(false);

                            if (data.type == 'success')
                            {
                                let text = '<h5 class="text-success text-center mt-4">"<?php echo e(__('Your Account is Complete. We are Redirecting You to Your Admin Dashboard')); ?>"</h5>';
                                submit_button.parent().after(text);
                                setTimeout(function (){
                                    location.href = data.url;
                                }, 3000);
                            }
                            else if(data.type == 'danger')
                            {
                                formContainer.find('.error-wrap').html('<ul class="alert alert-danger"></ul>');
                                formContainer.find('.error-wrap ul').append('<li>' + data.msg + '</li>')
                                $('input[name=subdomain]').val('');

                                submit_button.text('Create Account');
                                submit_button.prop('disabled', false);
                            }else{
                                submit_button.parent().parent().after('<div class="alert alert-'+data.type+' mt-2">' + data.msg + '</div>');
                            }
                        },
                        error: function (data) {
                            let i = 0;

                            buttonLoop(false);

                            submit_button.text('Create Account');
                            submit_button.prop('disabled', false);

                            var response = data.responseJSON.errors
                            formContainer.find('.error-wrap').html('<ul class="alert alert-danger"></ul>');
                            $.each(response, function (value, index) {
                                formContainer.find('.error-wrap ul').append('<li> <span>' + ++i + '.</span> ' + index + '</li>');
                            });
                        }
                    });
                });

                let row = $('.theme-row');
                let col = row.children('.col-3').first();
                let name = col.find('.theme-wrapper').data('name');
                $('p.modal_theme').find('span').text(name);


                $(document).on('click', '.theme-wrapper', function (e){
                    let el = $(this);
                    let theme_slug = el.data('theme');
                    let theme_name = el.data('name');

                    $('.theme-wrapper').removeClass('selected_theme');
                    el.addClass('selected_theme');

                    let text = '<h4 class="selected_text"><i class="las la-check-circle"></i></h4>';
                    $('.selected_text').remove();
                    el.append(text);

                    $('input#theme-slug').val(theme_slug);
                    $('p.modal_theme').find('span').text(theme_name);
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('landlord.frontend.frontend-page-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/xgenious/Desktop/xgenious/localhost/multisaas-update/core/resources/views/landlord/frontend/pages/package/view-plan.blade.php ENDPATH**/ ?>