<?php
    $post_img = null;
    $user_lang = get_user_lang();
?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e($job->getTranslation('title',$user_lang)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    <?php echo e($job->getTranslation('title',$user_lang)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta-data'); ?>
    <?php echo render_page_meta_data($job); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="jobDetails section-padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="singleJobDetails mb-24">
                        <div class="company">
                            <!-- Clients -->
                            <div class="companyCap">
                                <div class="companyLogo">
                                    <?php echo render_image_markup_by_attachment_id($job->image); ?>

                                </div>
                                <div class="companyTitle">
                                    <span class="title"><?php echo e($job->getTranslation('title',$user_lang)); ?> </span>
                                    <div class="d-flex align-items-center">
                                        <p class="c-title"><?php echo e($job->getTranslation('company_name',$user_lang)); ?></p>
                                        <span class="location"><i class="fa-solid fa-location-dot icon"></i><?php echo e($job->getTranslation('job_location',$user_lang)); ?></span>
                                    </div>
                                    <p class="pera"><?php echo e($job->created_at?->diffForHumans()); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- job requirement -->
                    <ul class="jobRequirement mb-40">
                        <li class="listItem"><span><?php echo e(__('Experience')); ?> : </span> <?php echo e($job->experience); ?></li>
                        <li class="listItem"><span><?php echo e(__('Employee type')); ?> : </span> <?php echo e(\Modules\Job\Enums\EmployeeTypeEnum::getText($job->employee_type)); ?></li>
                        <li class="listItem"><span><?php echo e(__('Salary offer')); ?> : </span> <?php echo e(amount_with_currency_symbol($job->salary_offer)); ?></li>
                        <li class="listItem"><span><?php echo e(__('Working days')); ?>  : </span> <?php echo e($job->working_days); ?></li>
                        <li class="listItem"><span><?php echo e(__('Working type')); ?> : </span> <?php echo e(\Modules\Job\Enums\WorkingTypeEnum::getText($job->working_type)); ?></li>
                        <li class="listItem"><span><?php echo e(__('Job Location')); ?> :  </span> <?php echo e($job->getTranslation('job_location',$user_lang)); ?></li>
                        <li class="listItem"><span><?php echo e(__('Job Designation')); ?>: </span> <?php echo e($job->getTranslation('designation',$user_lang)); ?></li>
                        <li class="listItem"><span><?php echo e(__('Deadline')); ?> : </span> <?php echo e($job->deadline); ?></li>

                    </ul>

                    <div class="description mb-40">
                        <?php echo $job->getTranslation('description',$user_lang); ?>

                    </div>

                    <!-- job requirement -->
                    <ul class="jobRequirement mb-40">
                        <?php if(!empty($job->application_fee_status)): ?>
                            <li class="listItem text-primary"><strong class="text-primary"><?php echo e(__('Application Fee')); ?>  : </strong> <?php echo e(amount_with_currency_symbol($job->application_fee)); ?></li>
                        <?php endif; ?>
                    </ul>

                    <div class="btn-wrapper d-flex flex-wrap mb-30">
                        <a href="<?php echo e(route('tenant.frontend.job.payment',$job->slug)); ?>" class="cmn-btn4 hero-btn2 mr-15 mb-10"><?php echo e(__('Apply')); ?></a>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'job::components.frontend.job.related-job','data' => ['allRelatedJobs' => $all_related_jobs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('job::frontend.job.related-job'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['allRelatedJobs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($all_related_jobs)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->yieldContent("custom-ajax-scripts"); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('tenant.frontend.frontend-page-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/multipurposesass/public_html/core/resources/views/themes/eCommerce/frontend/job/job-single.blade.php ENDPATH**/ ?>