<?php $__env->startSection('title'); ?>
   <?php echo e(__('All Payment History')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('All Payment History')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('section'); ?>

    <?php if(count($payment_log_histories) > 0): ?>
        <div class="table-responsive">

            <div class="alert alert-success">
                <h4 class="text-center "><?php echo e(__('All Payment History of')); ?> : <?php echo e($domain_name); ?></h4>
            </div>
            <a href="<?php echo e(route('landlord.user.home')); ?>" class="btn btn-info btn-sm my-3"><?php echo e(__('Go to Dashboard')); ?></a>

            <table class="table table-striped">
                <thead>
                <tr>
                    <th scope="col"><?php echo e(__('Package Order Info')); ?></th>
                    <th scope="col"><?php echo e(__('Payment Status')); ?></th>
                </tr>
                </thead>
                <tbody>

                <?php $__currentLoopData = $payment_log_histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <div class="user-dahsboard-order-info-wrap">
                                <h5 class="title"><?php echo e($data->package_name); ?></h5>
                                <div class="div">
                                    <small class="d-block"><strong><?php echo e(__('Transaction ID')); ?> : </strong> <?php echo e($data->transaction_id); ?></small>
                                    <small class="d-block"><strong><?php echo e(__('Package Price')); ?> : </strong> <?php echo e(amount_with_currency_symbol($data->package?->price)); ?></small>
                                    <?php if(!empty($data->coupon_discount)): ?>
                                        <small class="d-block"><strong><?php echo e(__('Coupon Discount')); ?> : </strong> <?php echo e(amount_with_currency_symbol($data->coupon_discount)); ?></small>
                                    <?php endif; ?>
                                    <small class="d-block"><strong><?php echo e(__('Paid Amount')); ?> : </strong> <?php echo e(amount_with_currency_symbol($data->package_price)); ?></small>
                                    <small class="d-block"><strong><?php echo e(__('Payment Gateway')); ?> : </strong> <?php echo e(str_replace('_',' ', ucwords($data->package_gateway))); ?></small>

                                    <?php
                                        $tenant_relation = $data->tenant?->custom_domain;
                                        $domain_condition = !empty($tenant_relation->custom_domain) && $tenant_relation->custom_domain_status == 'connected' ? $tenant_relation->custom_domain :  $data->tenant_id.'.'.env('CENTRAL_DOMAIN')
                                    ?>

                                    <small class="d-block mb-2"><strong><?php echo e(__('Domain')); ?> : <span class="text-primary"><?php echo e($domain_condition); ?></span></strong>
                                    <small class="d-block"><strong><?php echo e(__('Order Status')); ?> : </strong>
                                        <?php if($data->status == 'pending'): ?>
                                            <span class="alert alert-warning text-capitalize alert-sm alert-small"><?php echo e(__($data->status )); ?></span>
                                        <?php elseif($data->status == 'cancel'): ?>
                                            <span class="alert alert-danger text-capitalize alert-sm alert-small"><?php echo e(__($data->status)); ?></span>
                                        <?php elseif($data->status == 'in_progress'): ?>
                                            <span class="alert alert-info text-capitalize alert-sm alert-small"><?php echo e(str_replace('_',' ',$data->status)); ?></span>
                                        <?php elseif($data->status == 'trial'): ?>
                                            <span class="alert alert-danger text-capitalize alert-sm alert-small"><?php echo e(str_replace('_',' ',$data->status)); ?></span>
                                        <?php else: ?>
                                            <span class="alert alert-success text-capitalize alert-sm alert-small"><?php echo e($data->status); ?></span>
                                        <?php endif; ?>
                                    </small>

                                    <small class="d-block"><strong><?php echo e(__('Start Date:')); ?></strong> <?php echo e(date('d-m-Y',strtotime($data->start_date))); ?></small>
                                    <?php if($data->status != 'trial'): ?>
                                        <?php
                                            $expire_date_condition = $data->package?->type == 2  ? __('Lifetime') : date('d-m-Y',strtotime($data->expire_date));
                                        ?>
                                      <small class="d-block"><strong><?php echo e(__('Expire Date:')); ?></strong> <?php echo e($expire_date_condition); ?></small>
                                    <?php endif; ?>
                                    <?php if($data->status == 'trial'): ?>
                                        <small class="d-block"><strong><?php echo e(__('Trial Expire Date:')); ?></strong> <?php echo e(date('d-m-Y',strtotime($data->expire_date))); ?></small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>
                        <td class="user-dahsboard-status-info-wrap">
                            <?php if($data->payment_status == 'pending' && $data->status == 'pending'): ?>
                                <span class="alert alert-warning text-capitalize alert-sm"><?php echo e($data->payment_status); ?></span>
                            <?php elseif($data->payment_status == 'pending' && $data->status == 'trial'): ?>
                                <span class="alert alert-warning text-capitalize alert-sm"><?php echo e($data->payment_status); ?></span>
                            <?php else: ?>
                                <?php if($data->payment_status == 'complete'): ?>
                                    <span class="alert alert-success text-capitalize alert-sm d-inline-block"><?php echo e($data->payment_status); ?></span>
                                <?php else: ?>
                                    <span class="alert alert-warning text-capitalize alert-sm d-inline-block"><?php echo e($data->payment_status); ?></span>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if($data->payment_status == 'complete' && $data->is_renew == 1): ?>
                                    <span class="alert alert-primary text-capitalize alert-sm d-inline-block"><?php echo e(__('Renewed')); ?></span>
                            <?php endif; ?>
                        </td>


                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="blog-pagination">
            <?php echo e($payment_log_histories->links()); ?>

        </div>
    <?php else: ?>
        <div class="alert alert-warning"><?php echo e(__('No Order Found')); ?></div>
    <?php endif; ?>


<?php $__env->stopSection(); ?>



<?php echo $__env->make('landlord.frontend.user.dashboard.user-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/multipurposesass/public_html/core/resources/views/landlord/frontend/user/dashboard/package-order-history.blade.php ENDPATH**/ ?>