<?php $__env->startSection('title'); ?>
    <?php echo e(__('Appointment Payment Success For:')); ?> <?php echo e(optional($payment_details->appointment)->getTranslation('title',get_user_lang())); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Appointment Payment Success For:')); ?> <?php echo e(optional($payment_details->appointment)->getTranslation('title',get_user_lang())); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="donation-success-page-content padding-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="order-success-area">
                        <?php if($payment_details->payment_status == 'pending'): ?>
                            <div class="alert alert-warning">
                                <h6 class="text-center"><?php echo e(__('Your Payment Sent successfully..! It is in now under admin review..!')); ?></h6>
                            </div>
                        <?php else: ?>
                        <h1 class="title mb-5 text-center"><?php echo e(__('Payment Completed Successfully')); ?></h1>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-6">
                    <h2 class="billing-title mb-4"><?php echo e(__('Appointment Details')); ?></h2>
                    <ul class="billing-details">

                        <li><strong><?php echo e(__('Name')); ?>:</strong> <?php echo e($payment_details->name); ?></li>
                        <li><strong><?php echo e(__('Email')); ?>:</strong> <?php echo e($payment_details->email); ?></li>
                        <li><strong><?php echo e(__('Amount')); ?>:</strong> <?php echo e(amount_with_currency_symbol($payment_details->total_amount)); ?></li>

                        <li><strong><?php echo e(__('Appointment Date')); ?>:</strong> <?php echo e($payment_details->appointment_date); ?></li>
                        <li><strong><?php echo e(__('Appointment Time')); ?>:</strong> <?php echo e($payment_details->appointment_time); ?></li>

                        <li><strong><?php echo e(__('Payment Method')); ?>:</strong>  <?php echo e(str_replace('_',' ',$payment_details->payment_gateway)); ?></li>
                        <li><strong><?php echo e(__('Payment Status')); ?>:</strong> <?php echo e($payment_details->payment_status); ?></li>
                        <li><strong><?php echo e(__('Transaction id')); ?>:</strong> <?php echo e($payment_details->transaction_id); ?></li>

                    </ul>
                    <div class="donation-wrap donation-success-page">
                        <div class="contribute-single-item">
                            <div class="thumb mt-3">
                                <?php echo render_image_markup_by_attachment_id($payment_details->appointment->image,'','grid'); ?>

                                <div class="thumb-content">
                                </div>
                            </div>
                            <div class="content mt-4">
                                <a href="<?php echo e(route('tenant.frontend.appointment.single',$payment_details->appointment?->slug)); ?>"><h4 class="title"><?php echo e(optional($payment_details->appointment)->getTranslation('title',get_user_lang())); ?></h4></a>
                                <p><?php echo e(strip_tags(Str::words(strip_tags($payment_details->appointment?->getTranslation('description',get_user_lang())),40))); ?></p>
                                <div class="btn-wrapper mt-3">
                                    <a href="<?php echo e(route('tenant.frontend.appointment.order.page',$payment_details->appointment?->slug)); ?>" class="barberShop_cmn_btn btn_bg_1"><?php echo e(__('Book Again')); ?></a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="btn-wrapper margin-top-40">
                        <?php if(auth()->guard('web')->check()): ?>
                            <div class="btn-wrapper">
                                <a href="<?php echo e(route('tenant.user.home')); ?>" class="barberShop_cmn_btn btn_bg_1"><?php echo e(__('Go To Dashboard')); ?></a>
                            </div>
                        <?php else: ?>
                            <div class="btn-wrapper">
                                <a href="<?php echo e(url('/')); ?>" class="barberShop_cmn_btn btn_bg_1"><?php echo e(__('Back To Home')); ?></a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('tenant.frontend.frontend-page-master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/multipurposesass/public_html/core/resources/views/themes/barber-shop/frontend/appointments/appointment-payment/success.blade.php ENDPATH**/ ?>