
<section class="relatedProduct mt-5 pb-100">
    <div class="container">
        <div class="row mb-40">
            <div class="col-xl-6 col-lg-12 col-md-10 col-sm-10">
                <div class="section-tittle mb-0">
                    <h2><?php echo e(__('Related Products')); ?></h2>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="global-slick-init slider-inner-margin arrowStyleFour" data-infinite="false" data-arrows="true" data-dots="false" data-slidesToShow="4" data-swipeToSlide="true" data-autoplay="true" data-autoplaySpeed="2500" data-prevArrow='<div class="prev-icon"><i class="las la-angle-left"></i></div>'
                     data-nextArrow='<div class="next-icon"><i class="las la-angle-right"></i></div>' data-responsive='[{"breakpoint": 1800,"settings": {"slidesToShow": 4}},{"breakpoint": 1600,"settings": {"slidesToShow": 4}},{"breakpoint": 1400,"settings": {"slidesToShow": 3}},{"breakpoint": 1200,"settings": {"slidesToShow": 3}},{"breakpoint": 991,"settings": {"slidesToShow": 2}},{"breakpoint": 768, "settings": {"slidesToShow": 2}},{"breakpoint": 576, "settings": {"slidesToShow": 1}}]'>

                    <?php $__currentLoopData = $related_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            if ($loop->odd) {
                                    $delay = 1;
                                    $class = 'fadeInDown';
                                }
                            else {
                                $delay = 2;
                                $class = 'fadeInUp';
                            }

                            $img_data = get_attachment_image_by_id($product->image_id, 'grid');
                            $img = !empty($img_data) ? $img_data['img_url'] : '';
                            $alt = !empty($img_data) ? $img_data['img_alt'] : '';

                            $discount = null;
                            if ($product->price)
                                {
                                    $discount = round(($product->sale_price / $product->price)*100, 2);
                                }
                        ?>


                        <div class="singleProduct">
                        <div class="productImg imgEffect2">
                            <a href="<?php echo e(route('tenant.shop.product.details', $product->slug)); ?>">
                                <img src="<?php echo e($img); ?>" alt="<?php echo e($alt); ?>">
                            </a>
                            <!-- sticker -->



                                <div class="sticky-wrap">
                                    <?php if($product->inventory?->stock_count < 1): ?>
                                        <span class="sticky stickyStye outStock"><?php echo e(__('Out of stock')); ?></span>
                                    <?php endif; ?>

                                    <?php if(!empty($product->badge)): ?>
                                        <span class="sticky stickyStye"> <?php echo e($product?->badge?->name); ?> </span>
                                    <?php endif; ?>
                                </div>



                            <?php echo $__env->make('product::frontend.option-feature', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        </div>
                        <div class="productCap">
                            <h5>
                                <a href="<?php echo e(route('tenant.shop.product.details', $product->slug)); ?>" class="title"><?php echo e(Str::words($product->name, 4)); ?></a>
                            </h5>

                            <?php echo render_product_star_rating_markup_with_count($product); ?>


                            <?php if($product->inventory?->stock_count > 0): ?>
                                <span class="quintity avilable"><?php echo e(__('In Stock')); ?> <span class="quintityNumber">(<?php echo e($product->inventory?->stock_count); ?>)</span> </span>
                            <?php else: ?>
                                <span class="quintity text-danger"><?php echo e(__('Stock Out')); ?> <span class="quintityNumber">(<?php echo e($product->inventory?->stock_count); ?>)</span> </span>
                            <?php endif; ?>

                            <div class="productPrice">
                                <?php echo product_prices($product, 'color-two'); ?>

                            </div>
                            <div class="btn-wrapper">

                                <?php if(count($product->inventoryDetail) > 0 ): ?>
                                    <a href="<?php echo e(route('tenant.shop.product.details',$product->slug)); ?>" class="cmn-btn-outline3 w-100"><?php echo e(__('View')); ?></a>
                                <?php else: ?>
                                    <a href="#!" data-product_id="<?php echo e($product->id); ?>" class="cmn-btn-outline3 w-100 add-to-buy-now-btn"><?php echo e(__('Buy Now')); ?></a>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/multipurposesass/public_html/core/Modules/Product/Resources/views/frontend/shop/product_details/partials/featured-product.blade.php ENDPATH**/ ?>