<?php

namespace Database\Seeders\Tenant\ModuleData;

use App\Models\Language;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;

class LanguageSeed extends Seeder
{
    public static function run()
    {
        if(!Schema::hasTable('languages')){
            Schema::create('languages', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('name');
                $table->string('slug',10);
                $table->unsignedBigInteger('direction')->default(0);
                $table->unsignedBigInteger('status')->default(0);
                $table->unsignedBigInteger('default')->default(0);
                $table->timestamps();
            });
        }


        $landlord_seletec_default_language = get_static_option_central('landlord_default_language_set');
        $enUS = 1;
        $ar = 0;
        if(!empty($landlord_seletec_default_language)){
            $enUS = $landlord_seletec_default_language === "en_US" ? 1 : 0;
            $ar = $landlord_seletec_default_language === "ar" ? 1 : 0;
        }

        if($enUS == 0 && $ar == 0){

            Language::create([
                'name' => __('English (USA)'),
                'direction' => 0,
                'slug' => 'en_US',
                'status' => 1,
                'default' => 1
            ]);

            Language::create([
                'name' => __('Arabic'),
                'direction' => 1,
                'slug' => 'ar',
                'status' => 1,
                'default' => 0
            ]);
        }else{
            Language::create([
                'name' => __('English (USA)'),
                'direction' => 0,
                'slug' => 'en_US',
                'status' => 1,
                'default' => $enUS
            ]);

            Language::create([
                'name' => __('Arabic'),
                'direction' => 1,
                'slug' => 'ar',
                'status' => 1,
                'default' => $ar
            ]);
        }


    }
}
