<?php

namespace Database\Seeders\Tenant\ModuleData\Donation;

use App\Helpers\SeederHelpers\JsonDataModifier;
use Illuminate\Support\Facades\DB;
use Modules\Blog\Entities\Blog;
use Modules\Donation\Entities\Donation;
use Modules\Donation\Entities\DonationCategory;

class DonationSeed
{

    public static function execute()
    {
        $object = new JsonDataModifier('donation','donation');
        $data = $object->getColumnData([
            'title',
            'description',
            'slug',
            'status',
            'amount',
            'image',
            'creator_id',
            'created_by',
            'category_id',
            'deadline',
            'popular',
            'views',
            'faq',
        ]);

        Donation::insert($data);
    }

}
