<?php

namespace Database\Seeders\Tenant\ModuleData\Donation;

use App\Helpers\SeederHelpers\JsonDataModifier;
use Illuminate\Support\Facades\DB;
use Modules\Blog\Entities\Blog;
use Modules\Donation\Entities\Donation;
use Modules\Donation\Entities\DonationActivity;

class DonationActivitySeed
{

    public static function execute()
    {
        $object = new JsonDataModifier('donation', 'donation-activities');
        $data = $object->getColumnData([
            'title',
            'description',
            'slug',
            'status',
            'image',
            'category_id',
        ]);

        DonationActivity::insert($data);

    }
}
