<?php

namespace App\Console\Commands;

use App\Events\TenantCronjobEvent;
use App\Events\TenantNotificationEvent;
use App\Mail\BasicMail;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class AccountRemoval extends Command
{

    protected $signature = 'account:remove';
    protected $description = 'Command description';


    public function __construct()
    {
        parent::__construct();
    }


    public function handle()
    {

        $all_user = \App\Models\User::all();

        foreach ($all_user as $user){

            $tenants  = $user->tenant_details;

            foreach ($tenants as $tenant){

                if(!empty($tenant)){

                    $payment_log = \App\Models\PaymentLogs::where(['tenant_id' => $tenant->id, 'payment_status' => 'complete'])->first();

                    $day_list = json_decode(get_static_option('tenant_account_delete_notify_mail_days')) ?? [];
                    $remove_day = get_static_option('account_remove_day_within_expiration');

                    rsort($day_list);
                    $cron_qty = 0;
                    foreach ($day_list as $day){

                        if (\Carbon\Carbon::parse($payment_log->expire_date)->addDay($remove_day)->subDay($day)->lessThan(\Carbon\Carbon::today())){
                            $message['subject'] = 'Account will be deleted -' . get_static_option('site_' . get_default_language() . '_title');
                            $message['body'] = 'Your Account will be removed within ' . ($day) .  ' days.  Please subscribe to a plan before we remove your account ';
                            $message['body'].= '<br><br><a href="'.route('landlord.frontend.plan.order',optional($payment_log->package)->id).'">'.__('Go to plan page').'</a>';
                            Mail::to($payment_log->email)->send(new BasicMail( $message['body'],$message['subject']));


                            //Cronjob Store Event
                            $event_data = [
                                'id' =>  $payment_log->id,
                                'title' =>  __('Account Removal Cronjob'),
                                'type' =>  'account_removal',
                                'running_qty' => $cron_qty + 1,
                            ];
                            event(new TenantCronjobEvent($event_data));
                            //Cronjob Store Event

                            break;
                        }

                    }
                }
            }


        }



        return 0;
    }
}
